/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.ailanguage.model.DetectDominantLanguageResult;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectDominantLanguageConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(DetectDominantLanguageConverter.class);

    public static DetectDominantLanguageRequest interceptRequest(DetectDominantLanguageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DetectDominantLanguageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getDetectDominantLanguageDetails()), (String)"detectDominantLanguageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20221001").path("actions").path("detectDominantLanguage");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, DetectDominantLanguageResponse> fromResponse() {
        return DetectDominantLanguageConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, DetectDominantLanguageResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, DetectDominantLanguageResponse> transformer = new Function<Response, DetectDominantLanguageResponse>(){

            @Override
            public DetectDominantLanguageResponse apply(Response rawResponse) {
                Optional sunsetHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(DetectDominantLanguageResult.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(DetectDominantLanguageResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DetectDominantLanguageResponse.Builder builder = DetectDominantLanguageResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.detectDominantLanguageResult((DetectDominantLanguageResult)((Object)response.getItem()));
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((sunsetHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"sunset")).isPresent()) {
                    builder.sunset((String)HeaderUtils.toValue((String)"sunset", (String)((String)((List)sunsetHeader.get()).get(0)), String.class));
                }
                DetectDominantLanguageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

