/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TextClassificationModelMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="accuracy")
    private final Float accuracy;
    @JsonProperty(value="microF1")
    private final Float microF1;
    @JsonProperty(value="microPrecision")
    private final Float microPrecision;
    @JsonProperty(value="microRecall")
    private final Float microRecall;
    @JsonProperty(value="macroF1")
    private final Float macroF1;
    @JsonProperty(value="macroPrecision")
    private final Float macroPrecision;
    @JsonProperty(value="macroRecall")
    private final Float macroRecall;
    @JsonProperty(value="weightedF1")
    private final Float weightedF1;
    @JsonProperty(value="weightedPrecision")
    private final Float weightedPrecision;
    @JsonProperty(value="weightedRecall")
    private final Float weightedRecall;

    @Deprecated
    @ConstructorProperties(value={"accuracy", "microF1", "microPrecision", "microRecall", "macroF1", "macroPrecision", "macroRecall", "weightedF1", "weightedPrecision", "weightedRecall"})
    public TextClassificationModelMetrics(Float accuracy, Float microF1, Float microPrecision, Float microRecall, Float macroF1, Float macroPrecision, Float macroRecall, Float weightedF1, Float weightedPrecision, Float weightedRecall) {
        this.accuracy = accuracy;
        this.microF1 = microF1;
        this.microPrecision = microPrecision;
        this.microRecall = microRecall;
        this.macroF1 = macroF1;
        this.macroPrecision = macroPrecision;
        this.macroRecall = macroRecall;
        this.weightedF1 = weightedF1;
        this.weightedPrecision = weightedPrecision;
        this.weightedRecall = weightedRecall;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getAccuracy() {
        return this.accuracy;
    }

    public Float getMicroF1() {
        return this.microF1;
    }

    public Float getMicroPrecision() {
        return this.microPrecision;
    }

    public Float getMicroRecall() {
        return this.microRecall;
    }

    public Float getMacroF1() {
        return this.macroF1;
    }

    public Float getMacroPrecision() {
        return this.macroPrecision;
    }

    public Float getMacroRecall() {
        return this.macroRecall;
    }

    public Float getWeightedF1() {
        return this.weightedF1;
    }

    public Float getWeightedPrecision() {
        return this.weightedPrecision;
    }

    public Float getWeightedRecall() {
        return this.weightedRecall;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TextClassificationModelMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("accuracy=").append(String.valueOf(this.accuracy));
        sb.append(", microF1=").append(String.valueOf(this.microF1));
        sb.append(", microPrecision=").append(String.valueOf(this.microPrecision));
        sb.append(", microRecall=").append(String.valueOf(this.microRecall));
        sb.append(", macroF1=").append(String.valueOf(this.macroF1));
        sb.append(", macroPrecision=").append(String.valueOf(this.macroPrecision));
        sb.append(", macroRecall=").append(String.valueOf(this.macroRecall));
        sb.append(", weightedF1=").append(String.valueOf(this.weightedF1));
        sb.append(", weightedPrecision=").append(String.valueOf(this.weightedPrecision));
        sb.append(", weightedRecall=").append(String.valueOf(this.weightedRecall));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextClassificationModelMetrics)) {
            return false;
        }
        TextClassificationModelMetrics other = (TextClassificationModelMetrics)((Object)o);
        return Objects.equals(this.accuracy, other.accuracy) && Objects.equals(this.microF1, other.microF1) && Objects.equals(this.microPrecision, other.microPrecision) && Objects.equals(this.microRecall, other.microRecall) && Objects.equals(this.macroF1, other.macroF1) && Objects.equals(this.macroPrecision, other.macroPrecision) && Objects.equals(this.macroRecall, other.macroRecall) && Objects.equals(this.weightedF1, other.weightedF1) && Objects.equals(this.weightedPrecision, other.weightedPrecision) && Objects.equals(this.weightedRecall, other.weightedRecall) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.accuracy == null ? 43 : this.accuracy.hashCode());
        result = result * 59 + (this.microF1 == null ? 43 : this.microF1.hashCode());
        result = result * 59 + (this.microPrecision == null ? 43 : this.microPrecision.hashCode());
        result = result * 59 + (this.microRecall == null ? 43 : this.microRecall.hashCode());
        result = result * 59 + (this.macroF1 == null ? 43 : this.macroF1.hashCode());
        result = result * 59 + (this.macroPrecision == null ? 43 : this.macroPrecision.hashCode());
        result = result * 59 + (this.macroRecall == null ? 43 : this.macroRecall.hashCode());
        result = result * 59 + (this.weightedF1 == null ? 43 : this.weightedF1.hashCode());
        result = result * 59 + (this.weightedPrecision == null ? 43 : this.weightedPrecision.hashCode());
        result = result * 59 + (this.weightedRecall == null ? 43 : this.weightedRecall.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="accuracy")
        private Float accuracy;
        @JsonProperty(value="microF1")
        private Float microF1;
        @JsonProperty(value="microPrecision")
        private Float microPrecision;
        @JsonProperty(value="microRecall")
        private Float microRecall;
        @JsonProperty(value="macroF1")
        private Float macroF1;
        @JsonProperty(value="macroPrecision")
        private Float macroPrecision;
        @JsonProperty(value="macroRecall")
        private Float macroRecall;
        @JsonProperty(value="weightedF1")
        private Float weightedF1;
        @JsonProperty(value="weightedPrecision")
        private Float weightedPrecision;
        @JsonProperty(value="weightedRecall")
        private Float weightedRecall;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder accuracy(Float accuracy) {
            this.accuracy = accuracy;
            this.__explicitlySet__.add("accuracy");
            return this;
        }

        public Builder microF1(Float microF1) {
            this.microF1 = microF1;
            this.__explicitlySet__.add("microF1");
            return this;
        }

        public Builder microPrecision(Float microPrecision) {
            this.microPrecision = microPrecision;
            this.__explicitlySet__.add("microPrecision");
            return this;
        }

        public Builder microRecall(Float microRecall) {
            this.microRecall = microRecall;
            this.__explicitlySet__.add("microRecall");
            return this;
        }

        public Builder macroF1(Float macroF1) {
            this.macroF1 = macroF1;
            this.__explicitlySet__.add("macroF1");
            return this;
        }

        public Builder macroPrecision(Float macroPrecision) {
            this.macroPrecision = macroPrecision;
            this.__explicitlySet__.add("macroPrecision");
            return this;
        }

        public Builder macroRecall(Float macroRecall) {
            this.macroRecall = macroRecall;
            this.__explicitlySet__.add("macroRecall");
            return this;
        }

        public Builder weightedF1(Float weightedF1) {
            this.weightedF1 = weightedF1;
            this.__explicitlySet__.add("weightedF1");
            return this;
        }

        public Builder weightedPrecision(Float weightedPrecision) {
            this.weightedPrecision = weightedPrecision;
            this.__explicitlySet__.add("weightedPrecision");
            return this;
        }

        public Builder weightedRecall(Float weightedRecall) {
            this.weightedRecall = weightedRecall;
            this.__explicitlySet__.add("weightedRecall");
            return this;
        }

        public TextClassificationModelMetrics build() {
            TextClassificationModelMetrics model = new TextClassificationModelMetrics(this.accuracy, this.microF1, this.microPrecision, this.microRecall, this.macroF1, this.macroPrecision, this.macroRecall, this.weightedF1, this.weightedPrecision, this.weightedRecall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TextClassificationModelMetrics model) {
            if (model.wasPropertyExplicitlySet("accuracy")) {
                this.accuracy(model.getAccuracy());
            }
            if (model.wasPropertyExplicitlySet("microF1")) {
                this.microF1(model.getMicroF1());
            }
            if (model.wasPropertyExplicitlySet("microPrecision")) {
                this.microPrecision(model.getMicroPrecision());
            }
            if (model.wasPropertyExplicitlySet("microRecall")) {
                this.microRecall(model.getMicroRecall());
            }
            if (model.wasPropertyExplicitlySet("macroF1")) {
                this.macroF1(model.getMacroF1());
            }
            if (model.wasPropertyExplicitlySet("macroPrecision")) {
                this.macroPrecision(model.getMacroPrecision());
            }
            if (model.wasPropertyExplicitlySet("macroRecall")) {
                this.macroRecall(model.getMacroRecall());
            }
            if (model.wasPropertyExplicitlySet("weightedF1")) {
                this.weightedF1(model.getWeightedF1());
            }
            if (model.wasPropertyExplicitlySet("weightedPrecision")) {
                this.weightedPrecision(model.getWeightedPrecision());
            }
            if (model.wasPropertyExplicitlySet("weightedRecall")) {
                this.weightedRecall(model.getWeightedRecall());
            }
            return this;
        }
    }
}

