/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageSentimentsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class BatchDetectLanguageSentimentsRequest
extends BmcRequest<BatchDetectLanguageSentimentsDetails> {
    private BatchDetectLanguageSentimentsDetails batchDetectLanguageSentimentsDetails;
    private String opcRequestId;
    private List<Level> level;

    public BatchDetectLanguageSentimentsDetails getBatchDetectLanguageSentimentsDetails() {
        return this.batchDetectLanguageSentimentsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Level> getLevel() {
        return this.level;
    }

    @InternalSdk
    public BatchDetectLanguageSentimentsDetails getBody$() {
        return this.batchDetectLanguageSentimentsDetails;
    }

    public Builder toBuilder() {
        return new Builder().batchDetectLanguageSentimentsDetails(this.batchDetectLanguageSentimentsDetails).opcRequestId(this.opcRequestId).level(this.level);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",batchDetectLanguageSentimentsDetails=").append(String.valueOf((Object)this.batchDetectLanguageSentimentsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",level=").append(String.valueOf(this.level));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchDetectLanguageSentimentsRequest)) {
            return false;
        }
        BatchDetectLanguageSentimentsRequest other = (BatchDetectLanguageSentimentsRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.batchDetectLanguageSentimentsDetails, (Object)other.batchDetectLanguageSentimentsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.level, other.level);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.batchDetectLanguageSentimentsDetails == null ? 43 : this.batchDetectLanguageSentimentsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private BatchDetectLanguageSentimentsDetails batchDetectLanguageSentimentsDetails = null;
        private String opcRequestId = null;
        private List<Level> level = null;

        public Builder batchDetectLanguageSentimentsDetails(BatchDetectLanguageSentimentsDetails batchDetectLanguageSentimentsDetails) {
            this.batchDetectLanguageSentimentsDetails = batchDetectLanguageSentimentsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder level(List<Level> level) {
            this.level = level;
            return this;
        }

        public Builder level(Level singularValue) {
            return this.level(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BatchDetectLanguageSentimentsRequest o) {
            this.batchDetectLanguageSentimentsDetails(o.getBatchDetectLanguageSentimentsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.level(o.getLevel());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BatchDetectLanguageSentimentsRequest build() {
            BatchDetectLanguageSentimentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BatchDetectLanguageSentimentsDetails body) {
            this.batchDetectLanguageSentimentsDetails(body);
            return this;
        }

        public BatchDetectLanguageSentimentsRequest buildWithoutInvocationCallback() {
            BatchDetectLanguageSentimentsRequest request = new BatchDetectLanguageSentimentsRequest();
            request.batchDetectLanguageSentimentsDetails = this.batchDetectLanguageSentimentsDetails;
            request.opcRequestId = this.opcRequestId;
            request.level = this.level;
            return request;
        }
    }

    public static enum Level {
        Aspect("ASPECT"),
        Sentence("SENTENCE");

        private final String value;
        private static Map<String, Level> map;

        private Level(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Level create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Level: " + key);
        }

        static {
            map = new HashMap<String, Level>();
            for (Level v : Level.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

