/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.ailanguage.AIServiceLanguage;
import com.oracle.bmc.ailanguage.AIServiceLanguagePaginators;
import com.oracle.bmc.ailanguage.AIServiceLanguageWaiters;
import com.oracle.bmc.ailanguage.model.BatchDetectDominantLanguageResult;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageEntitiesResult;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageKeyPhrasesResult;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguagePiiEntitiesResult;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageSentimentsResult;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageTextClassificationResult;
import com.oracle.bmc.ailanguage.model.BatchLanguageTranslationResult;
import com.oracle.bmc.ailanguage.model.DetectDominantLanguageResult;
import com.oracle.bmc.ailanguage.model.DetectLanguageEntitiesResult;
import com.oracle.bmc.ailanguage.model.DetectLanguageKeyPhrasesResult;
import com.oracle.bmc.ailanguage.model.DetectLanguageSentimentsResult;
import com.oracle.bmc.ailanguage.model.DetectLanguageTextClassificationResult;
import com.oracle.bmc.ailanguage.model.Endpoint;
import com.oracle.bmc.ailanguage.model.EndpointCollection;
import com.oracle.bmc.ailanguage.model.EvaluationResultCollection;
import com.oracle.bmc.ailanguage.model.Model;
import com.oracle.bmc.ailanguage.model.ModelCollection;
import com.oracle.bmc.ailanguage.model.ModelTypeInfo;
import com.oracle.bmc.ailanguage.model.Project;
import com.oracle.bmc.ailanguage.model.ProjectCollection;
import com.oracle.bmc.ailanguage.model.WorkRequest;
import com.oracle.bmc.ailanguage.model.WorkRequestErrorCollection;
import com.oracle.bmc.ailanguage.model.WorkRequestLogCollection;
import com.oracle.bmc.ailanguage.model.WorkRequestSummaryCollection;
import com.oracle.bmc.ailanguage.requests.BatchDetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguagePiiEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.BatchLanguageTranslationRequest;
import com.oracle.bmc.ailanguage.requests.ChangeEndpointCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.CreateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.CreateModelRequest;
import com.oracle.bmc.ailanguage.requests.CreateProjectRequest;
import com.oracle.bmc.ailanguage.requests.DeleteEndpointRequest;
import com.oracle.bmc.ailanguage.requests.DeleteModelRequest;
import com.oracle.bmc.ailanguage.requests.DeleteProjectRequest;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.GetEndpointRequest;
import com.oracle.bmc.ailanguage.requests.GetModelRequest;
import com.oracle.bmc.ailanguage.requests.GetModelTypeRequest;
import com.oracle.bmc.ailanguage.requests.GetProjectRequest;
import com.oracle.bmc.ailanguage.requests.GetWorkRequestRequest;
import com.oracle.bmc.ailanguage.requests.ListEndpointsRequest;
import com.oracle.bmc.ailanguage.requests.ListEvaluationResultsRequest;
import com.oracle.bmc.ailanguage.requests.ListModelsRequest;
import com.oracle.bmc.ailanguage.requests.ListProjectsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.ailanguage.requests.UpdateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.UpdateModelRequest;
import com.oracle.bmc.ailanguage.requests.UpdateProjectRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguagePiiEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.BatchLanguageTranslationResponse;
import com.oracle.bmc.ailanguage.responses.ChangeEndpointCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.CreateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.CreateModelResponse;
import com.oracle.bmc.ailanguage.responses.CreateProjectResponse;
import com.oracle.bmc.ailanguage.responses.DeleteEndpointResponse;
import com.oracle.bmc.ailanguage.responses.DeleteModelResponse;
import com.oracle.bmc.ailanguage.responses.DeleteProjectResponse;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.GetEndpointResponse;
import com.oracle.bmc.ailanguage.responses.GetModelResponse;
import com.oracle.bmc.ailanguage.responses.GetModelTypeResponse;
import com.oracle.bmc.ailanguage.responses.GetProjectResponse;
import com.oracle.bmc.ailanguage.responses.GetWorkRequestResponse;
import com.oracle.bmc.ailanguage.responses.ListEndpointsResponse;
import com.oracle.bmc.ailanguage.responses.ListEvaluationResultsResponse;
import com.oracle.bmc.ailanguage.responses.ListModelsResponse;
import com.oracle.bmc.ailanguage.responses.ListProjectsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.ailanguage.responses.UpdateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.UpdateModelResponse;
import com.oracle.bmc.ailanguage.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceLanguageClient
extends BaseSyncClient
implements AIServiceLanguage {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICELANGUAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://language.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceLanguageClient.class);
    private final AIServiceLanguageWaiters waiters;
    private final AIServiceLanguagePaginators paginators;

    AIServiceLanguageClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AIServiceLanguage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AIServiceLanguageWaiters(executorService, this);
        this.paginators = new AIServiceLanguagePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request) {
        Objects.requireNonNull(request.getBatchDetectDominantLanguageDetails(), "batchDetectDominantLanguageDetails is required");
        return (BatchDetectDominantLanguageResponse)this.clientCall(request, BatchDetectDominantLanguageResponse::builder).logger(LOG, "batchDetectDominantLanguage").serviceDetails("AIServiceLanguage", "BatchDetectDominantLanguage", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectDominantLanguage/BatchDetectDominantLanguage").method(Method.POST).requestBuilder(BatchDetectDominantLanguageRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectDominantLanguage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectDominantLanguageResult.class, BatchDetectDominantLanguageResponse.Builder::batchDetectDominantLanguageResult).handleResponseHeaderString("opc-request-id", BatchDetectDominantLanguageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchDetectLanguageEntitiesResponse batchDetectLanguageEntities(BatchDetectLanguageEntitiesRequest request) {
        Objects.requireNonNull(request.getBatchDetectLanguageEntitiesDetails(), "batchDetectLanguageEntitiesDetails is required");
        return (BatchDetectLanguageEntitiesResponse)this.clientCall(request, BatchDetectLanguageEntitiesResponse::builder).logger(LOG, "batchDetectLanguageEntities").serviceDetails("AIServiceLanguage", "BatchDetectLanguageEntities", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageEntities/BatchDetectLanguageEntities").method(Method.POST).requestBuilder(BatchDetectLanguageEntitiesRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectLanguageEntities").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectLanguageEntitiesResult.class, BatchDetectLanguageEntitiesResponse.Builder::batchDetectLanguageEntitiesResult).handleResponseHeaderString("opc-request-id", BatchDetectLanguageEntitiesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchDetectLanguageKeyPhrasesResponse batchDetectLanguageKeyPhrases(BatchDetectLanguageKeyPhrasesRequest request) {
        Objects.requireNonNull(request.getBatchDetectLanguageKeyPhrasesDetails(), "batchDetectLanguageKeyPhrasesDetails is required");
        return (BatchDetectLanguageKeyPhrasesResponse)this.clientCall(request, BatchDetectLanguageKeyPhrasesResponse::builder).logger(LOG, "batchDetectLanguageKeyPhrases").serviceDetails("AIServiceLanguage", "BatchDetectLanguageKeyPhrases", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageKeyPhrases/BatchDetectLanguageKeyPhrases").method(Method.POST).requestBuilder(BatchDetectLanguageKeyPhrasesRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectLanguageKeyPhrases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectLanguageKeyPhrasesResult.class, BatchDetectLanguageKeyPhrasesResponse.Builder::batchDetectLanguageKeyPhrasesResult).handleResponseHeaderString("opc-request-id", BatchDetectLanguageKeyPhrasesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchDetectLanguagePiiEntitiesResponse batchDetectLanguagePiiEntities(BatchDetectLanguagePiiEntitiesRequest request) {
        Objects.requireNonNull(request.getBatchDetectLanguagePiiEntitiesDetails(), "batchDetectLanguagePiiEntitiesDetails is required");
        return (BatchDetectLanguagePiiEntitiesResponse)this.clientCall(request, BatchDetectLanguagePiiEntitiesResponse::builder).logger(LOG, "batchDetectLanguagePiiEntities").serviceDetails("AIServiceLanguage", "BatchDetectLanguagePiiEntities", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguagePiiEntities/BatchDetectLanguagePiiEntities").method(Method.POST).requestBuilder(BatchDetectLanguagePiiEntitiesRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectLanguagePiiEntities").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectLanguagePiiEntitiesResult.class, BatchDetectLanguagePiiEntitiesResponse.Builder::batchDetectLanguagePiiEntitiesResult).handleResponseHeaderString("opc-request-id", BatchDetectLanguagePiiEntitiesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchDetectLanguageSentimentsResponse batchDetectLanguageSentiments(BatchDetectLanguageSentimentsRequest request) {
        Objects.requireNonNull(request.getBatchDetectLanguageSentimentsDetails(), "batchDetectLanguageSentimentsDetails is required");
        return (BatchDetectLanguageSentimentsResponse)this.clientCall(request, BatchDetectLanguageSentimentsResponse::builder).logger(LOG, "batchDetectLanguageSentiments").serviceDetails("AIServiceLanguage", "BatchDetectLanguageSentiments", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageSentiments/BatchDetectLanguageSentiments").method(Method.POST).requestBuilder(BatchDetectLanguageSentimentsRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectLanguageSentiments").appendListQueryParam("level", request.getLevel(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectLanguageSentimentsResult.class, BatchDetectLanguageSentimentsResponse.Builder::batchDetectLanguageSentimentsResult).handleResponseHeaderString("opc-request-id", BatchDetectLanguageSentimentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchDetectLanguageTextClassificationResponse batchDetectLanguageTextClassification(BatchDetectLanguageTextClassificationRequest request) {
        Objects.requireNonNull(request.getBatchDetectLanguageTextClassificationDetails(), "batchDetectLanguageTextClassificationDetails is required");
        return (BatchDetectLanguageTextClassificationResponse)this.clientCall(request, BatchDetectLanguageTextClassificationResponse::builder).logger(LOG, "batchDetectLanguageTextClassification").serviceDetails("AIServiceLanguage", "BatchDetectLanguageTextClassification", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageTextClassification/BatchDetectLanguageTextClassification").method(Method.POST).requestBuilder(BatchDetectLanguageTextClassificationRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchDetectLanguageTextClassification").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchDetectLanguageTextClassificationResult.class, BatchDetectLanguageTextClassificationResponse.Builder::batchDetectLanguageTextClassificationResult).handleResponseHeaderString("opc-request-id", BatchDetectLanguageTextClassificationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BatchLanguageTranslationResponse batchLanguageTranslation(BatchLanguageTranslationRequest request) {
        Objects.requireNonNull(request.getBatchLanguageTranslationDetails(), "batchLanguageTranslationDetails is required");
        return (BatchLanguageTranslationResponse)this.clientCall(request, BatchLanguageTranslationResponse::builder).logger(LOG, "batchLanguageTranslation").serviceDetails("AIServiceLanguage", "BatchLanguageTranslation", "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchLanguageTranslation/BatchLanguageTranslation").method(Method.POST).requestBuilder(BatchLanguageTranslationRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("batchLanguageTranslation").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(BatchLanguageTranslationResult.class, BatchLanguageTranslationResponse.Builder::batchLanguageTranslationResult).handleResponseHeaderString("opc-request-id", BatchLanguageTranslationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeEndpointCompartmentResponse changeEndpointCompartment(ChangeEndpointCompartmentRequest request) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEndpointCompartmentDetails(), "changeEndpointCompartmentDetails is required");
        return (ChangeEndpointCompartmentResponse)this.clientCall(request, ChangeEndpointCompartmentResponse::builder).logger(LOG, "changeEndpointCompartment").serviceDetails("AIServiceLanguage", "ChangeEndpointCompartment", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ChangeEndpointCompartment").method(Method.POST).requestBuilder(ChangeEndpointCompartmentRequest::builder).basePath("/20221001").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeEndpointCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return (ChangeModelCompartmentResponse)this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AIServiceLanguage", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20221001").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return (ChangeProjectCompartmentResponse)this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AIServiceLanguage", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20221001").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest request) {
        Objects.requireNonNull(request.getCreateEndpointDetails(), "createEndpointDetails is required");
        return (CreateEndpointResponse)this.clientCall(request, CreateEndpointResponse::builder).logger(LOG, "createEndpoint").serviceDetails("AIServiceLanguage", "CreateEndpoint", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/CreateEndpoint").method(Method.POST).requestBuilder(CreateEndpointRequest::builder).basePath("/20221001").appendPathParam("endpoints").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Endpoint.class, CreateEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", CreateEndpointResponse.Builder::etag).handleResponseHeaderString("location", CreateEndpointResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateEndpointResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return (CreateModelResponse)this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AIServiceLanguage", "CreateModel", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/CreateModel").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20221001").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).handleResponseHeaderString("location", CreateModelResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return (CreateProjectResponse)this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AIServiceLanguage", "CreateProject", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/CreateProject").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20221001").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest request) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return (DeleteEndpointResponse)this.clientCall(request, DeleteEndpointResponse::builder).logger(LOG, "deleteEndpoint").serviceDetails("AIServiceLanguage", "DeleteEndpoint", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/DeleteEndpoint").method(Method.DELETE).requestBuilder(DeleteEndpointRequest::builder).basePath("/20221001").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEndpointResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (DeleteModelResponse)this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AIServiceLanguage", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20221001").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectResponse)this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AIServiceLanguage", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20221001").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest request) {
        Objects.requireNonNull(request.getDetectDominantLanguageDetails(), "detectDominantLanguageDetails is required");
        return (DetectDominantLanguageResponse)this.clientCall(request, DetectDominantLanguageResponse::builder).logger(LOG, "detectDominantLanguage").serviceDetails("AIServiceLanguage", "DetectDominantLanguage", "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectDominantLanguage/DetectDominantLanguage").method(Method.POST).requestBuilder(DetectDominantLanguageRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("detectDominantLanguage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectDominantLanguageResult.class, DetectDominantLanguageResponse.Builder::detectDominantLanguageResult).handleResponseHeaderString("opc-request-id", DetectDominantLanguageResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DetectDominantLanguageResponse.Builder::sunset).callSync();
    }

    @Override
    public DetectLanguageEntitiesResponse detectLanguageEntities(DetectLanguageEntitiesRequest request) {
        Objects.requireNonNull(request.getDetectLanguageEntitiesDetails(), "detectLanguageEntitiesDetails is required");
        return (DetectLanguageEntitiesResponse)this.clientCall(request, DetectLanguageEntitiesResponse::builder).logger(LOG, "detectLanguageEntities").serviceDetails("AIServiceLanguage", "DetectLanguageEntities", "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageEntities/DetectLanguageEntities").method(Method.POST).requestBuilder(DetectLanguageEntitiesRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("detectLanguageEntities").appendEnumQueryParam("modelVersion", (BmcEnum)request.getModelVersion()).appendQueryParam("isPii", (Object)request.getIsPii()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectLanguageEntitiesResult.class, DetectLanguageEntitiesResponse.Builder::detectLanguageEntitiesResult).handleResponseHeaderString("opc-request-id", DetectLanguageEntitiesResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DetectLanguageEntitiesResponse.Builder::sunset).callSync();
    }

    @Override
    public DetectLanguageKeyPhrasesResponse detectLanguageKeyPhrases(DetectLanguageKeyPhrasesRequest request) {
        Objects.requireNonNull(request.getDetectLanguageKeyPhrasesDetails(), "detectLanguageKeyPhrasesDetails is required");
        return (DetectLanguageKeyPhrasesResponse)this.clientCall(request, DetectLanguageKeyPhrasesResponse::builder).logger(LOG, "detectLanguageKeyPhrases").serviceDetails("AIServiceLanguage", "DetectLanguageKeyPhrases", "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageKeyPhrases/DetectLanguageKeyPhrases").method(Method.POST).requestBuilder(DetectLanguageKeyPhrasesRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("detectLanguageKeyPhrases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectLanguageKeyPhrasesResult.class, DetectLanguageKeyPhrasesResponse.Builder::detectLanguageKeyPhrasesResult).handleResponseHeaderString("opc-request-id", DetectLanguageKeyPhrasesResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DetectLanguageKeyPhrasesResponse.Builder::sunset).callSync();
    }

    @Override
    public DetectLanguageSentimentsResponse detectLanguageSentiments(DetectLanguageSentimentsRequest request) {
        Objects.requireNonNull(request.getDetectLanguageSentimentsDetails(), "detectLanguageSentimentsDetails is required");
        return (DetectLanguageSentimentsResponse)this.clientCall(request, DetectLanguageSentimentsResponse::builder).logger(LOG, "detectLanguageSentiments").serviceDetails("AIServiceLanguage", "DetectLanguageSentiments", "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageSentiments/DetectLanguageSentiments").method(Method.POST).requestBuilder(DetectLanguageSentimentsRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("detectLanguageSentiments").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectLanguageSentimentsResult.class, DetectLanguageSentimentsResponse.Builder::detectLanguageSentimentsResult).handleResponseHeaderString("opc-request-id", DetectLanguageSentimentsResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DetectLanguageSentimentsResponse.Builder::sunset).callSync();
    }

    @Override
    public DetectLanguageTextClassificationResponse detectLanguageTextClassification(DetectLanguageTextClassificationRequest request) {
        Objects.requireNonNull(request.getDetectLanguageTextClassificationDetails(), "detectLanguageTextClassificationDetails is required");
        return (DetectLanguageTextClassificationResponse)this.clientCall(request, DetectLanguageTextClassificationResponse::builder).logger(LOG, "detectLanguageTextClassification").serviceDetails("AIServiceLanguage", "DetectLanguageTextClassification", "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageTextClassification/DetectLanguageTextClassification").method(Method.POST).requestBuilder(DetectLanguageTextClassificationRequest::builder).basePath("/20221001").appendPathParam("actions").appendPathParam("detectLanguageTextClassification").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DetectLanguageTextClassificationResult.class, DetectLanguageTextClassificationResponse.Builder::detectLanguageTextClassificationResult).handleResponseHeaderString("opc-request-id", DetectLanguageTextClassificationResponse.Builder::opcRequestId).handleResponseHeaderString("sunset", DetectLanguageTextClassificationResponse.Builder::sunset).callSync();
    }

    @Override
    public GetEndpointResponse getEndpoint(GetEndpointRequest request) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        return (GetEndpointResponse)this.clientCall(request, GetEndpointResponse::builder).logger(LOG, "getEndpoint").serviceDetails("AIServiceLanguage", "GetEndpoint", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/GetEndpoint").method(Method.GET).requestBuilder(GetEndpointRequest::builder).basePath("/20221001").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Endpoint.class, GetEndpointResponse.Builder::endpoint).handleResponseHeaderString("etag", GetEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEndpointResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelResponse)this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AIServiceLanguage", "GetModel", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20221001").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelTypeResponse getModelType(GetModelTypeRequest request) {
        Validate.notBlank((String)request.getModelType(), (String)"modelType must not be blank", (Object[])new Object[0]);
        return (GetModelTypeResponse)this.clientCall(request, GetModelTypeResponse::builder).logger(LOG, "getModelType").serviceDetails("AIServiceLanguage", "GetModelType", "https://docs.oracle.com/iaas/api/#/en/language/20221001/ModelTypeInfo/GetModelType").method(Method.GET).requestBuilder(GetModelTypeRequest::builder).basePath("/20221001").appendPathParam("modelTypes").appendPathParam(request.getModelType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelTypeInfo.class, GetModelTypeResponse.Builder::modelTypeInfo).handleResponseHeaderString("opc-request-id", GetModelTypeResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectResponse)this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AIServiceLanguage", "GetProject", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20221001").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AIServiceLanguage", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20221001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEndpointsResponse)this.clientCall(request, ListEndpointsResponse::builder).logger(LOG, "listEndpoints").serviceDetails("AIServiceLanguage", "ListEndpoints", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ListEndpoints").method(Method.GET).requestBuilder(ListEndpointsRequest::builder).basePath("/20221001").appendPathParam("endpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("endpointId", (Object)request.getEndpointId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("modelId", (Object)request.getModelId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EndpointCollection.class, ListEndpointsResponse.Builder::endpointCollection).handleResponseHeaderString("opc-request-id", ListEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEndpointsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEvaluationResultsResponse listEvaluationResults(ListEvaluationResultsRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (ListEvaluationResultsResponse)this.clientCall(request, ListEvaluationResultsResponse::builder).logger(LOG, "listEvaluationResults").serviceDetails("AIServiceLanguage", "ListEvaluationResults", "https://docs.oracle.com/iaas/api/#/en/language/20221001/EvaluationResultCollection/ListEvaluationResults").method(Method.GET).requestBuilder(ListEvaluationResultsRequest::builder).basePath("/20221001").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("evaluationResults").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EvaluationResultCollection.class, ListEvaluationResultsResponse.Builder::evaluationResultCollection).handleResponseHeaderString("opc-request-id", ListEvaluationResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEvaluationResultsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListModelsResponse)this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AIServiceLanguage", "ListModels", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20221001").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("modelId", (Object)request.getModelId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProjectsResponse)this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AIServiceLanguage", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20221001").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AIServiceLanguage", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20221001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AIServiceLanguage", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20221001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AIServiceLanguage", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20221001").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest request) {
        Validate.notBlank((String)request.getEndpointId(), (String)"endpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEndpointDetails(), "updateEndpointDetails is required");
        return (UpdateEndpointResponse)this.clientCall(request, UpdateEndpointResponse::builder).logger(LOG, "updateEndpoint").serviceDetails("AIServiceLanguage", "UpdateEndpoint", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/UpdateEndpoint").method(Method.PUT).requestBuilder(UpdateEndpointRequest::builder).basePath("/20221001").appendPathParam("endpoints").appendPathParam(request.getEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateEndpointResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return (UpdateModelResponse)this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AIServiceLanguage", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20221001").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return (UpdateProjectResponse)this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AIServiceLanguage", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20221001").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public AIServiceLanguageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AIServiceLanguagePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceLanguageClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceLanguageClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceLanguageClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceLanguageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "ailanguage";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"ailanguage");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AIServiceLanguageClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceLanguageClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

