/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ailanguage.AIServiceLanguage;
import com.oracle.bmc.ailanguage.model.EndpointSummary;
import com.oracle.bmc.ailanguage.model.EvaluationResultSummary;
import com.oracle.bmc.ailanguage.model.ModelSummary;
import com.oracle.bmc.ailanguage.model.ProjectSummary;
import com.oracle.bmc.ailanguage.model.WorkRequestError;
import com.oracle.bmc.ailanguage.model.WorkRequestLog;
import com.oracle.bmc.ailanguage.model.WorkRequestSummary;
import com.oracle.bmc.ailanguage.requests.ListEndpointsRequest;
import com.oracle.bmc.ailanguage.requests.ListEvaluationResultsRequest;
import com.oracle.bmc.ailanguage.requests.ListModelsRequest;
import com.oracle.bmc.ailanguage.requests.ListProjectsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.ailanguage.responses.ListEndpointsResponse;
import com.oracle.bmc.ailanguage.responses.ListEvaluationResultsResponse;
import com.oracle.bmc.ailanguage.responses.ListModelsResponse;
import com.oracle.bmc.ailanguage.responses.ListProjectsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AIServiceLanguagePaginators {
    private final AIServiceLanguage client;

    public AIServiceLanguagePaginators(AIServiceLanguage client) {
        this.client = client;
    }

    public Iterable<ListEndpointsResponse> listEndpointsResponseIterator(final ListEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return AIServiceLanguagePaginators.this.client.listEndpoints(request);
            }
        });
    }

    public Iterable<EndpointSummary> listEndpointsRecordIterator(final ListEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEndpointsRequest.Builder>(){

            @Override
            public ListEndpointsRequest.Builder get() {
                return ListEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEndpointsResponse, String>(){

            @Override
            public String apply(ListEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEndpointsRequest.Builder>, ListEndpointsRequest>(){

            @Override
            public ListEndpointsRequest apply(RequestBuilderAndToken<ListEndpointsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEndpointsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEndpointsRequest, ListEndpointsResponse>(){

            @Override
            public ListEndpointsResponse apply(ListEndpointsRequest request) {
                return AIServiceLanguagePaginators.this.client.listEndpoints(request);
            }
        }, (Function)new Function<ListEndpointsResponse, List<EndpointSummary>>(){

            @Override
            public List<EndpointSummary> apply(ListEndpointsResponse response) {
                return response.getEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListEvaluationResultsResponse> listEvaluationResultsResponseIterator(final ListEvaluationResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListEvaluationResultsRequest.Builder>(){

            @Override
            public ListEvaluationResultsRequest.Builder get() {
                return ListEvaluationResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEvaluationResultsResponse, String>(){

            @Override
            public String apply(ListEvaluationResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEvaluationResultsRequest.Builder>, ListEvaluationResultsRequest>(){

            @Override
            public ListEvaluationResultsRequest apply(RequestBuilderAndToken<ListEvaluationResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEvaluationResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEvaluationResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEvaluationResultsRequest, ListEvaluationResultsResponse>(){

            @Override
            public ListEvaluationResultsResponse apply(ListEvaluationResultsRequest request) {
                return AIServiceLanguagePaginators.this.client.listEvaluationResults(request);
            }
        });
    }

    public Iterable<EvaluationResultSummary> listEvaluationResultsRecordIterator(final ListEvaluationResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListEvaluationResultsRequest.Builder>(){

            @Override
            public ListEvaluationResultsRequest.Builder get() {
                return ListEvaluationResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListEvaluationResultsResponse, String>(){

            @Override
            public String apply(ListEvaluationResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListEvaluationResultsRequest.Builder>, ListEvaluationResultsRequest>(){

            @Override
            public ListEvaluationResultsRequest apply(RequestBuilderAndToken<ListEvaluationResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListEvaluationResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListEvaluationResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListEvaluationResultsRequest, ListEvaluationResultsResponse>(){

            @Override
            public ListEvaluationResultsResponse apply(ListEvaluationResultsRequest request) {
                return AIServiceLanguagePaginators.this.client.listEvaluationResults(request);
            }
        }, (Function)new Function<ListEvaluationResultsResponse, List<EvaluationResultSummary>>(){

            @Override
            public List<EvaluationResultSummary> apply(ListEvaluationResultsResponse response) {
                return response.getEvaluationResultCollection().getItems();
            }
        });
    }

    public Iterable<ListModelsResponse> listModelsResponseIterator(final ListModelsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AIServiceLanguagePaginators.this.client.listModels(request);
            }
        });
    }

    public Iterable<ModelSummary> listModelsRecordIterator(final ListModelsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListModelsRequest.Builder>(){

            @Override
            public ListModelsRequest.Builder get() {
                return ListModelsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListModelsResponse, String>(){

            @Override
            public String apply(ListModelsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListModelsRequest.Builder>, ListModelsRequest>(){

            @Override
            public ListModelsRequest apply(RequestBuilderAndToken<ListModelsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListModelsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListModelsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListModelsRequest, ListModelsResponse>(){

            @Override
            public ListModelsResponse apply(ListModelsRequest request) {
                return AIServiceLanguagePaginators.this.client.listModels(request);
            }
        }, (Function)new Function<ListModelsResponse, List<ModelSummary>>(){

            @Override
            public List<ModelSummary> apply(ListModelsResponse response) {
                return response.getModelCollection().getItems();
            }
        });
    }

    public Iterable<ListProjectsResponse> listProjectsResponseIterator(final ListProjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AIServiceLanguagePaginators.this.client.listProjects(request);
            }
        });
    }

    public Iterable<ProjectSummary> listProjectsRecordIterator(final ListProjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProjectsRequest.Builder>(){

            @Override
            public ListProjectsRequest.Builder get() {
                return ListProjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProjectsResponse, String>(){

            @Override
            public String apply(ListProjectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProjectsRequest.Builder>, ListProjectsRequest>(){

            @Override
            public ListProjectsRequest apply(RequestBuilderAndToken<ListProjectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProjectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProjectsRequest, ListProjectsResponse>(){

            @Override
            public ListProjectsResponse apply(ListProjectsRequest request) {
                return AIServiceLanguagePaginators.this.client.listProjects(request);
            }
        }, (Function)new Function<ListProjectsResponse, List<ProjectSummary>>(){

            @Override
            public List<ProjectSummary> apply(ListProjectsResponse response) {
                return response.getProjectCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            @Override
            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return AIServiceLanguagePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

