/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.PiiEntity;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PiiEntityDocumentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="entities")
    private final List<PiiEntity> entities;
    @JsonProperty(value="maskedText")
    private final String maskedText;
    @JsonProperty(value="languageCode")
    private final String languageCode;

    @Deprecated
    @ConstructorProperties(value={"key", "entities", "maskedText", "languageCode"})
    public PiiEntityDocumentResult(String key, List<PiiEntity> entities, String maskedText, String languageCode) {
        this.key = key;
        this.entities = entities;
        this.maskedText = maskedText;
        this.languageCode = languageCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public List<PiiEntity> getEntities() {
        return this.entities;
    }

    public String getMaskedText() {
        return this.maskedText;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PiiEntityDocumentResult(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", entities=").append(String.valueOf(this.entities));
        sb.append(", maskedText=").append(String.valueOf(this.maskedText));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiiEntityDocumentResult)) {
            return false;
        }
        PiiEntityDocumentResult other = (PiiEntityDocumentResult)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.entities, other.entities) && Objects.equals(this.maskedText, other.maskedText) && Objects.equals(this.languageCode, other.languageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.entities == null ? 43 : this.entities.hashCode());
        result = result * 59 + (this.maskedText == null ? 43 : this.maskedText.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="entities")
        private List<PiiEntity> entities;
        @JsonProperty(value="maskedText")
        private String maskedText;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder entities(List<PiiEntity> entities) {
            this.entities = entities;
            this.__explicitlySet__.add("entities");
            return this;
        }

        public Builder maskedText(String maskedText) {
            this.maskedText = maskedText;
            this.__explicitlySet__.add("maskedText");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public PiiEntityDocumentResult build() {
            PiiEntityDocumentResult model = new PiiEntityDocumentResult(this.key, this.entities, this.maskedText, this.languageCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PiiEntityDocumentResult model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("entities")) {
                this.entities(model.getEntities());
            }
            if (model.wasPropertyExplicitlySet("maskedText")) {
                this.maskedText(model.getMaskedText());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            return this;
        }
    }
}

