/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.ailanguage.model.NamedEntityRecognitionModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedHealthNluModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedKeyPhraseExtractionModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedLanguageDetectionModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedNamedEntityRecognitionModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedPiiModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedSentimentAnalysisModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedSummarization;
import com.oracle.bmc.ailanguage.model.PreTrainedTextClassificationModelDetails;
import com.oracle.bmc.ailanguage.model.PreTrainedUniversalModel;
import com.oracle.bmc.ailanguage.model.TextClassificationModelDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=ModelDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PreTrainedKeyPhraseExtractionModelDetails.class, name="PRE_TRAINED_KEYPHRASE_EXTRACTION"), @JsonSubTypes.Type(value=PreTrainedHealthNluModelDetails.class, name="PRE_TRAINED_HEALTH_NLU"), @JsonSubTypes.Type(value=PreTrainedUniversalModel.class, name="PRE_TRAINED_UNIVERSAL"), @JsonSubTypes.Type(value=NamedEntityRecognitionModelDetails.class, name="NAMED_ENTITY_RECOGNITION"), @JsonSubTypes.Type(value=PreTrainedLanguageDetectionModelDetails.class, name="PRE_TRAINED_LANGUAGE_DETECTION"), @JsonSubTypes.Type(value=PreTrainedNamedEntityRecognitionModelDetails.class, name="PRE_TRAINED_NAMED_ENTITY_RECOGNITION"), @JsonSubTypes.Type(value=PreTrainedSentimentAnalysisModelDetails.class, name="PRE_TRAINED_SENTIMENT_ANALYSIS"), @JsonSubTypes.Type(value=PreTrainedTextClassificationModelDetails.class, name="PRE_TRAINED_TEXT_CLASSIFICATION"), @JsonSubTypes.Type(value=TextClassificationModelDetails.class, name="TEXT_CLASSIFICATION"), @JsonSubTypes.Type(value=PreTrainedSummarization.class, name="PRE_TRAINED_SUMMARIZATION"), @JsonSubTypes.Type(value=PreTrainedPiiModelDetails.class, name="PRE_TRAINED_PII")})
@JsonFilter(value="explicitlySetFilter")
public class ModelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="languageCode")
    private final String languageCode;

    @Deprecated
    @ConstructorProperties(value={"languageCode"})
    protected ModelDetails(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("languageCode=").append(String.valueOf(this.languageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelDetails)) {
            return false;
        }
        ModelDetails other = (ModelDetails)((Object)o);
        return Objects.equals(this.languageCode, other.languageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        NamedEntityRecognition("NAMED_ENTITY_RECOGNITION"),
        TextClassification("TEXT_CLASSIFICATION"),
        PreTrainedNamedEntityRecognition("PRE_TRAINED_NAMED_ENTITY_RECOGNITION"),
        PreTrainedTextClassification("PRE_TRAINED_TEXT_CLASSIFICATION"),
        PreTrainedSentimentAnalysis("PRE_TRAINED_SENTIMENT_ANALYSIS"),
        PreTrainedKeyphraseExtraction("PRE_TRAINED_KEYPHRASE_EXTRACTION"),
        PreTrainedLanguageDetection("PRE_TRAINED_LANGUAGE_DETECTION"),
        PreTrainedPii("PRE_TRAINED_PII"),
        PreTrainedTranslation("PRE_TRAINED_TRANSLATION"),
        PreTrainedHealthNlu("PRE_TRAINED_HEALTH_NLU"),
        PreTrainedSummarization("PRE_TRAINED_SUMMARIZATION"),
        PreTrainedUniversal("PRE_TRAINED_UNIVERSAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

