/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.ConfigurationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelMetadataDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelId")
    private final String modelId;
    @JsonProperty(value="endpointId")
    private final String endpointId;
    @JsonProperty(value="languageCode")
    private final String languageCode;
    @JsonProperty(value="configuration")
    private final Map<String, ConfigurationDetails> configuration;

    @Deprecated
    @ConstructorProperties(value={"modelType", "modelId", "endpointId", "languageCode", "configuration"})
    public ModelMetadataDetails(String modelType, String modelId, String endpointId, String languageCode, Map<String, ConfigurationDetails> configuration) {
        this.modelType = modelType;
        this.modelId = modelId;
        this.endpointId = endpointId;
        this.languageCode = languageCode;
        this.configuration = configuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public Map<String, ConfigurationDetails> getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelMetadataDetails(");
        sb.append("super=").append(super.toString());
        sb.append("modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelId=").append(String.valueOf(this.modelId));
        sb.append(", endpointId=").append(String.valueOf(this.endpointId));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(", configuration=").append(String.valueOf(this.configuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelMetadataDetails)) {
            return false;
        }
        ModelMetadataDetails other = (ModelMetadataDetails)((Object)o);
        return Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.configuration, other.configuration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + (this.configuration == null ? 43 : this.configuration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="endpointId")
        private String endpointId;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonProperty(value="configuration")
        private Map<String, ConfigurationDetails> configuration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            this.__explicitlySet__.add("endpointId");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public Builder configuration(Map<String, ConfigurationDetails> configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        public ModelMetadataDetails build() {
            ModelMetadataDetails model = new ModelMetadataDetails(this.modelType, this.modelId, this.endpointId, this.languageCode, this.configuration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelMetadataDetails model) {
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("endpointId")) {
                this.endpointId(model.getEndpointId());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("configuration")) {
                this.configuration(model.getConfiguration());
            }
            return this;
        }
    }
}

