/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.ClassMetrics;
import com.oracle.bmc.ailanguage.model.ConfusionMatrixDetails;
import com.oracle.bmc.ailanguage.model.EvaluationResults;
import com.oracle.bmc.ailanguage.model.TextClassificationModelMetrics;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TextClassificationEvaluationResults
extends EvaluationResults {
    @JsonProperty(value="metrics")
    private final TextClassificationModelMetrics metrics;
    @JsonProperty(value="classMetrics")
    private final List<ClassMetrics> classMetrics;
    @JsonProperty(value="confusionMatrix")
    private final Map<String, ConfusionMatrixDetails> confusionMatrix;
    @JsonProperty(value="labels")
    private final List<String> labels;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TextClassificationEvaluationResults(TextClassificationModelMetrics metrics, List<ClassMetrics> classMetrics, Map<String, ConfusionMatrixDetails> confusionMatrix, List<String> labels) {
        this.metrics = metrics;
        this.classMetrics = classMetrics;
        this.confusionMatrix = confusionMatrix;
        this.labels = labels;
    }

    public TextClassificationModelMetrics getMetrics() {
        return this.metrics;
    }

    public List<ClassMetrics> getClassMetrics() {
        return this.classMetrics;
    }

    public Map<String, ConfusionMatrixDetails> getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TextClassificationEvaluationResults(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", metrics=").append(String.valueOf((Object)this.metrics));
        sb.append(", classMetrics=").append(String.valueOf(this.classMetrics));
        sb.append(", confusionMatrix=").append(String.valueOf(this.confusionMatrix));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextClassificationEvaluationResults)) {
            return false;
        }
        TextClassificationEvaluationResults other = (TextClassificationEvaluationResults)((Object)o);
        return Objects.equals((Object)this.metrics, (Object)other.metrics) && Objects.equals(this.classMetrics, other.classMetrics) && Objects.equals(this.confusionMatrix, other.confusionMatrix) && Objects.equals(this.labels, other.labels) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.classMetrics == null ? 43 : this.classMetrics.hashCode());
        result = result * 59 + (this.confusionMatrix == null ? 43 : this.confusionMatrix.hashCode());
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metrics")
        private TextClassificationModelMetrics metrics;
        @JsonProperty(value="classMetrics")
        private List<ClassMetrics> classMetrics;
        @JsonProperty(value="confusionMatrix")
        private Map<String, ConfusionMatrixDetails> confusionMatrix;
        @JsonProperty(value="labels")
        private List<String> labels;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metrics(TextClassificationModelMetrics metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder classMetrics(List<ClassMetrics> classMetrics) {
            this.classMetrics = classMetrics;
            this.__explicitlySet__.add("classMetrics");
            return this;
        }

        public Builder confusionMatrix(Map<String, ConfusionMatrixDetails> confusionMatrix) {
            this.confusionMatrix = confusionMatrix;
            this.__explicitlySet__.add("confusionMatrix");
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public TextClassificationEvaluationResults build() {
            TextClassificationEvaluationResults model = new TextClassificationEvaluationResults(this.metrics, this.classMetrics, this.confusionMatrix, this.labels);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TextClassificationEvaluationResults model) {
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("classMetrics")) {
                this.classMetrics(model.getClassMetrics());
            }
            if (model.wasPropertyExplicitlySet("confusionMatrix")) {
                this.confusionMatrix(model.getConfusionMatrix());
            }
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            return this;
        }
    }
}

