/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.EvaluationResultSummary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TextClassificationModelEvaluationResult
extends EvaluationResultSummary {
    @JsonProperty(value="location")
    private final String location;
    @JsonProperty(value="trueLabels")
    private final List<String> trueLabels;
    @JsonProperty(value="predictedLabels")
    private final List<String> predictedLabels;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TextClassificationModelEvaluationResult(Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String location, List<String> trueLabels, List<String> predictedLabels) {
        super(freeformTags, definedTags);
        this.location = location;
        this.trueLabels = trueLabels;
        this.predictedLabels = predictedLabels;
    }

    public String getLocation() {
        return this.location;
    }

    public List<String> getTrueLabels() {
        return this.trueLabels;
    }

    public List<String> getPredictedLabels() {
        return this.predictedLabels;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TextClassificationModelEvaluationResult(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", location=").append(String.valueOf(this.location));
        sb.append(", trueLabels=").append(String.valueOf(this.trueLabels));
        sb.append(", predictedLabels=").append(String.valueOf(this.predictedLabels));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextClassificationModelEvaluationResult)) {
            return false;
        }
        TextClassificationModelEvaluationResult other = (TextClassificationModelEvaluationResult)((Object)o);
        return Objects.equals(this.location, other.location) && Objects.equals(this.trueLabels, other.trueLabels) && Objects.equals(this.predictedLabels, other.predictedLabels) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.trueLabels == null ? 43 : this.trueLabels.hashCode());
        result = result * 59 + (this.predictedLabels == null ? 43 : this.predictedLabels.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="location")
        private String location;
        @JsonProperty(value="trueLabels")
        private List<String> trueLabels;
        @JsonProperty(value="predictedLabels")
        private List<String> predictedLabels;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder trueLabels(List<String> trueLabels) {
            this.trueLabels = trueLabels;
            this.__explicitlySet__.add("trueLabels");
            return this;
        }

        public Builder predictedLabels(List<String> predictedLabels) {
            this.predictedLabels = predictedLabels;
            this.__explicitlySet__.add("predictedLabels");
            return this;
        }

        public TextClassificationModelEvaluationResult build() {
            TextClassificationModelEvaluationResult model = new TextClassificationModelEvaluationResult(this.freeformTags, this.definedTags, this.location, this.trueLabels, this.predictedLabels);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TextClassificationModelEvaluationResult model) {
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("trueLabels")) {
                this.trueLabels(model.getTrueLabels());
            }
            if (model.wasPropertyExplicitlySet("predictedLabels")) {
                this.predictedLabels(model.getPredictedLabels());
            }
            return this;
        }
    }
}

