/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.HealthEntity;
import com.oracle.bmc.ailanguage.model.RelationEntity;
import com.oracle.bmc.ailanguage.model.ResolvedEntities;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HealthEntityDocumentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="entities")
    private final List<HealthEntity> entities;
    @JsonProperty(value="relations")
    private final List<RelationEntity> relations;
    @JsonProperty(value="resolvedEntities")
    private final Map<String, ResolvedEntities> resolvedEntities;
    @JsonProperty(value="languageCode")
    private final String languageCode;

    @Deprecated
    @ConstructorProperties(value={"key", "entities", "relations", "resolvedEntities", "languageCode"})
    public HealthEntityDocumentResult(String key, List<HealthEntity> entities, List<RelationEntity> relations, Map<String, ResolvedEntities> resolvedEntities, String languageCode) {
        this.key = key;
        this.entities = entities;
        this.relations = relations;
        this.resolvedEntities = resolvedEntities;
        this.languageCode = languageCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public List<HealthEntity> getEntities() {
        return this.entities;
    }

    public List<RelationEntity> getRelations() {
        return this.relations;
    }

    public Map<String, ResolvedEntities> getResolvedEntities() {
        return this.resolvedEntities;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HealthEntityDocumentResult(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", entities=").append(String.valueOf(this.entities));
        sb.append(", relations=").append(String.valueOf(this.relations));
        sb.append(", resolvedEntities=").append(String.valueOf(this.resolvedEntities));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthEntityDocumentResult)) {
            return false;
        }
        HealthEntityDocumentResult other = (HealthEntityDocumentResult)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.entities, other.entities) && Objects.equals(this.relations, other.relations) && Objects.equals(this.resolvedEntities, other.resolvedEntities) && Objects.equals(this.languageCode, other.languageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.entities == null ? 43 : this.entities.hashCode());
        result = result * 59 + (this.relations == null ? 43 : this.relations.hashCode());
        result = result * 59 + (this.resolvedEntities == null ? 43 : this.resolvedEntities.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="entities")
        private List<HealthEntity> entities;
        @JsonProperty(value="relations")
        private List<RelationEntity> relations;
        @JsonProperty(value="resolvedEntities")
        private Map<String, ResolvedEntities> resolvedEntities;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder entities(List<HealthEntity> entities) {
            this.entities = entities;
            this.__explicitlySet__.add("entities");
            return this;
        }

        public Builder relations(List<RelationEntity> relations) {
            this.relations = relations;
            this.__explicitlySet__.add("relations");
            return this;
        }

        public Builder resolvedEntities(Map<String, ResolvedEntities> resolvedEntities) {
            this.resolvedEntities = resolvedEntities;
            this.__explicitlySet__.add("resolvedEntities");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public HealthEntityDocumentResult build() {
            HealthEntityDocumentResult model = new HealthEntityDocumentResult(this.key, this.entities, this.relations, this.resolvedEntities, this.languageCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HealthEntityDocumentResult model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("entities")) {
                this.entities(model.getEntities());
            }
            if (model.wasPropertyExplicitlySet("relations")) {
                this.relations(model.getRelations());
            }
            if (model.wasPropertyExplicitlySet("resolvedEntities")) {
                this.resolvedEntities(model.getResolvedEntities());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            return this;
        }
    }
}

