/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.InputConfiguration;
import com.oracle.bmc.ailanguage.model.InputLocation;
import com.oracle.bmc.ailanguage.model.ModelMetadataDetails;
import com.oracle.bmc.ailanguage.model.ObjectPrefixOutputLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Job
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="inputConfiguration")
    private final InputConfiguration inputConfiguration;
    @JsonProperty(value="modelMetadataDetails")
    private final List<ModelMetadataDetails> modelMetadataDetails;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;
    @JsonProperty(value="totalDocuments")
    private final Integer totalDocuments;
    @JsonProperty(value="pendingDocuments")
    private final Integer pendingDocuments;
    @JsonProperty(value="completedDocuments")
    private final Integer completedDocuments;
    @JsonProperty(value="failedDocuments")
    private final Integer failedDocuments;
    @JsonProperty(value="warningsCount")
    private final Integer warningsCount;
    @JsonProperty(value="outputLocation")
    private final ObjectPrefixOutputLocation outputLocation;
    @JsonProperty(value="ttlInDays")
    private final Integer ttlInDays;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeCompleted")
    private final Date timeCompleted;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "inputLocation", "inputConfiguration", "modelMetadataDetails", "compartmentId", "lifecycleState", "lifecycleDetails", "percentComplete", "totalDocuments", "pendingDocuments", "completedDocuments", "failedDocuments", "warningsCount", "outputLocation", "ttlInDays", "createdBy", "timeAccepted", "timeStarted", "timeCompleted"})
    public Job(String id, String displayName, String description, InputLocation inputLocation, InputConfiguration inputConfiguration, List<ModelMetadataDetails> modelMetadataDetails, String compartmentId, LifecycleState lifecycleState, String lifecycleDetails, Integer percentComplete, Integer totalDocuments, Integer pendingDocuments, Integer completedDocuments, Integer failedDocuments, Integer warningsCount, ObjectPrefixOutputLocation outputLocation, Integer ttlInDays, String createdBy, Date timeAccepted, Date timeStarted, Date timeCompleted) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.inputLocation = inputLocation;
        this.inputConfiguration = inputConfiguration;
        this.modelMetadataDetails = modelMetadataDetails;
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.percentComplete = percentComplete;
        this.totalDocuments = totalDocuments;
        this.pendingDocuments = pendingDocuments;
        this.completedDocuments = completedDocuments;
        this.failedDocuments = failedDocuments;
        this.warningsCount = warningsCount;
        this.outputLocation = outputLocation;
        this.ttlInDays = ttlInDays;
        this.createdBy = createdBy;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeCompleted = timeCompleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public InputConfiguration getInputConfiguration() {
        return this.inputConfiguration;
    }

    public List<ModelMetadataDetails> getModelMetadataDetails() {
        return this.modelMetadataDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public Integer getTotalDocuments() {
        return this.totalDocuments;
    }

    public Integer getPendingDocuments() {
        return this.pendingDocuments;
    }

    public Integer getCompletedDocuments() {
        return this.completedDocuments;
    }

    public Integer getFailedDocuments() {
        return this.failedDocuments;
    }

    public Integer getWarningsCount() {
        return this.warningsCount;
    }

    public ObjectPrefixOutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public Integer getTtlInDays() {
        return this.ttlInDays;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Job(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", inputConfiguration=").append(String.valueOf((Object)this.inputConfiguration));
        sb.append(", modelMetadataDetails=").append(String.valueOf(this.modelMetadataDetails));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", totalDocuments=").append(String.valueOf(this.totalDocuments));
        sb.append(", pendingDocuments=").append(String.valueOf(this.pendingDocuments));
        sb.append(", completedDocuments=").append(String.valueOf(this.completedDocuments));
        sb.append(", failedDocuments=").append(String.valueOf(this.failedDocuments));
        sb.append(", warningsCount=").append(String.valueOf(this.warningsCount));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", ttlInDays=").append(String.valueOf(this.ttlInDays));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeCompleted=").append(String.valueOf(this.timeCompleted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.inputConfiguration, (Object)other.inputConfiguration) && Objects.equals(this.modelMetadataDetails, other.modelMetadataDetails) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.totalDocuments, other.totalDocuments) && Objects.equals(this.pendingDocuments, other.pendingDocuments) && Objects.equals(this.completedDocuments, other.completedDocuments) && Objects.equals(this.failedDocuments, other.failedDocuments) && Objects.equals(this.warningsCount, other.warningsCount) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.ttlInDays, other.ttlInDays) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeCompleted, other.timeCompleted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.inputConfiguration == null ? 43 : this.inputConfiguration.hashCode());
        result = result * 59 + (this.modelMetadataDetails == null ? 43 : this.modelMetadataDetails.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.totalDocuments == null ? 43 : this.totalDocuments.hashCode());
        result = result * 59 + (this.pendingDocuments == null ? 43 : this.pendingDocuments.hashCode());
        result = result * 59 + (this.completedDocuments == null ? 43 : this.completedDocuments.hashCode());
        result = result * 59 + (this.failedDocuments == null ? 43 : this.failedDocuments.hashCode());
        result = result * 59 + (this.warningsCount == null ? 43 : this.warningsCount.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.ttlInDays == null ? 43 : this.ttlInDays.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeCompleted == null ? 43 : this.timeCompleted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="inputConfiguration")
        private InputConfiguration inputConfiguration;
        @JsonProperty(value="modelMetadataDetails")
        private List<ModelMetadataDetails> modelMetadataDetails;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonProperty(value="totalDocuments")
        private Integer totalDocuments;
        @JsonProperty(value="pendingDocuments")
        private Integer pendingDocuments;
        @JsonProperty(value="completedDocuments")
        private Integer completedDocuments;
        @JsonProperty(value="failedDocuments")
        private Integer failedDocuments;
        @JsonProperty(value="warningsCount")
        private Integer warningsCount;
        @JsonProperty(value="outputLocation")
        private ObjectPrefixOutputLocation outputLocation;
        @JsonProperty(value="ttlInDays")
        private Integer ttlInDays;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeCompleted")
        private Date timeCompleted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            this.__explicitlySet__.add("inputConfiguration");
            return this;
        }

        public Builder modelMetadataDetails(List<ModelMetadataDetails> modelMetadataDetails) {
            this.modelMetadataDetails = modelMetadataDetails;
            this.__explicitlySet__.add("modelMetadataDetails");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder totalDocuments(Integer totalDocuments) {
            this.totalDocuments = totalDocuments;
            this.__explicitlySet__.add("totalDocuments");
            return this;
        }

        public Builder pendingDocuments(Integer pendingDocuments) {
            this.pendingDocuments = pendingDocuments;
            this.__explicitlySet__.add("pendingDocuments");
            return this;
        }

        public Builder completedDocuments(Integer completedDocuments) {
            this.completedDocuments = completedDocuments;
            this.__explicitlySet__.add("completedDocuments");
            return this;
        }

        public Builder failedDocuments(Integer failedDocuments) {
            this.failedDocuments = failedDocuments;
            this.__explicitlySet__.add("failedDocuments");
            return this;
        }

        public Builder warningsCount(Integer warningsCount) {
            this.warningsCount = warningsCount;
            this.__explicitlySet__.add("warningsCount");
            return this;
        }

        public Builder outputLocation(ObjectPrefixOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder ttlInDays(Integer ttlInDays) {
            this.ttlInDays = ttlInDays;
            this.__explicitlySet__.add("ttlInDays");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeCompleted(Date timeCompleted) {
            this.timeCompleted = timeCompleted;
            this.__explicitlySet__.add("timeCompleted");
            return this;
        }

        public Job build() {
            Job model = new Job(this.id, this.displayName, this.description, this.inputLocation, this.inputConfiguration, this.modelMetadataDetails, this.compartmentId, this.lifecycleState, this.lifecycleDetails, this.percentComplete, this.totalDocuments, this.pendingDocuments, this.completedDocuments, this.failedDocuments, this.warningsCount, this.outputLocation, this.ttlInDays, this.createdBy, this.timeAccepted, this.timeStarted, this.timeCompleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Job model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("inputConfiguration")) {
                this.inputConfiguration(model.getInputConfiguration());
            }
            if (model.wasPropertyExplicitlySet("modelMetadataDetails")) {
                this.modelMetadataDetails(model.getModelMetadataDetails());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("totalDocuments")) {
                this.totalDocuments(model.getTotalDocuments());
            }
            if (model.wasPropertyExplicitlySet("pendingDocuments")) {
                this.pendingDocuments(model.getPendingDocuments());
            }
            if (model.wasPropertyExplicitlySet("completedDocuments")) {
                this.completedDocuments(model.getCompletedDocuments());
            }
            if (model.wasPropertyExplicitlySet("failedDocuments")) {
                this.failedDocuments(model.getFailedDocuments());
            }
            if (model.wasPropertyExplicitlySet("warningsCount")) {
                this.warningsCount(model.getWarningsCount());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("ttlInDays")) {
                this.ttlInDays(model.getTtlInDays());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeCompleted")) {
                this.timeCompleted(model.getTimeCompleted());
            }
            return this;
        }
    }
}

