/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RelationEntity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="subjectId")
    private final String subjectId;
    @JsonProperty(value="objectId")
    private final String objectId;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="score")
    private final Double score;

    @Deprecated
    @ConstructorProperties(value={"id", "subjectId", "objectId", "type", "score"})
    public RelationEntity(String id, String subjectId, String objectId, String type, Double score) {
        this.id = id;
        this.subjectId = subjectId;
        this.objectId = objectId;
        this.type = type;
        this.score = score;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getType() {
        return this.type;
    }

    public Double getScore() {
        return this.score;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RelationEntity(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", subjectId=").append(String.valueOf(this.subjectId));
        sb.append(", objectId=").append(String.valueOf(this.objectId));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", score=").append(String.valueOf(this.score));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationEntity)) {
            return false;
        }
        RelationEntity other = (RelationEntity)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.subjectId, other.subjectId) && Objects.equals(this.objectId, other.objectId) && Objects.equals(this.type, other.type) && Objects.equals(this.score, other.score) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.subjectId == null ? 43 : this.subjectId.hashCode());
        result = result * 59 + (this.objectId == null ? 43 : this.objectId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.score == null ? 43 : this.score.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="subjectId")
        private String subjectId;
        @JsonProperty(value="objectId")
        private String objectId;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="score")
        private Double score;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            this.__explicitlySet__.add("subjectId");
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.__explicitlySet__.add("objectId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder score(Double score) {
            this.score = score;
            this.__explicitlySet__.add("score");
            return this;
        }

        public RelationEntity build() {
            RelationEntity model = new RelationEntity(this.id, this.subjectId, this.objectId, this.type, this.score);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RelationEntity model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("subjectId")) {
                this.subjectId(model.getSubjectId());
            }
            if (model.wasPropertyExplicitlySet("objectId")) {
                this.objectId(model.getObjectId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("score")) {
                this.score(model.getScore());
            }
            return this;
        }
    }
}

