/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.Capabilities;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelTypeInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="versions")
    private final List<String> versions;
    @JsonProperty(value="capabilities")
    private final Map<String, Capabilities> capabilities;

    @Deprecated
    @ConstructorProperties(value={"versions", "capabilities"})
    public ModelTypeInfo(List<String> versions, Map<String, Capabilities> capabilities) {
        this.versions = versions;
        this.capabilities = capabilities;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public Map<String, Capabilities> getCapabilities() {
        return this.capabilities;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelTypeInfo(");
        sb.append("super=").append(super.toString());
        sb.append("versions=").append(String.valueOf(this.versions));
        sb.append(", capabilities=").append(String.valueOf(this.capabilities));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelTypeInfo)) {
            return false;
        }
        ModelTypeInfo other = (ModelTypeInfo)((Object)o);
        return Objects.equals(this.versions, other.versions) && Objects.equals(this.capabilities, other.capabilities) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.versions == null ? 43 : this.versions.hashCode());
        result = result * 59 + (this.capabilities == null ? 43 : this.capabilities.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="versions")
        private List<String> versions;
        @JsonProperty(value="capabilities")
        private Map<String, Capabilities> capabilities;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder versions(List<String> versions) {
            this.versions = versions;
            this.__explicitlySet__.add("versions");
            return this;
        }

        public Builder capabilities(Map<String, Capabilities> capabilities) {
            this.capabilities = capabilities;
            this.__explicitlySet__.add("capabilities");
            return this;
        }

        public ModelTypeInfo build() {
            ModelTypeInfo model = new ModelTypeInfo(this.versions, this.capabilities);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelTypeInfo model) {
            if (model.wasPropertyExplicitlySet("versions")) {
                this.versions(model.getVersions());
            }
            if (model.wasPropertyExplicitlySet("capabilities")) {
                this.capabilities(model.getCapabilities());
            }
            return this;
        }
    }
}

