/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.InputConfiguration;
import com.oracle.bmc.ailanguage.model.InputLocation;
import com.oracle.bmc.ailanguage.model.ModelMetadataDetails;
import com.oracle.bmc.ailanguage.model.ObjectPrefixOutputLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="inputConfiguration")
    private final InputConfiguration inputConfiguration;
    @JsonProperty(value="modelMetadataDetails")
    private final List<ModelMetadataDetails> modelMetadataDetails;
    @JsonProperty(value="outputLocation")
    private final ObjectPrefixOutputLocation outputLocation;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "compartmentId", "inputLocation", "inputConfiguration", "modelMetadataDetails", "outputLocation"})
    public CreateJobDetails(String displayName, String description, String compartmentId, InputLocation inputLocation, InputConfiguration inputConfiguration, List<ModelMetadataDetails> modelMetadataDetails, ObjectPrefixOutputLocation outputLocation) {
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.inputLocation = inputLocation;
        this.inputConfiguration = inputConfiguration;
        this.modelMetadataDetails = modelMetadataDetails;
        this.outputLocation = outputLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public InputConfiguration getInputConfiguration() {
        return this.inputConfiguration;
    }

    public List<ModelMetadataDetails> getModelMetadataDetails() {
        return this.modelMetadataDetails;
    }

    public ObjectPrefixOutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", inputConfiguration=").append(String.valueOf((Object)this.inputConfiguration));
        sb.append(", modelMetadataDetails=").append(String.valueOf(this.modelMetadataDetails));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobDetails)) {
            return false;
        }
        CreateJobDetails other = (CreateJobDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.inputConfiguration, (Object)other.inputConfiguration) && Objects.equals(this.modelMetadataDetails, other.modelMetadataDetails) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.inputConfiguration == null ? 43 : this.inputConfiguration.hashCode());
        result = result * 59 + (this.modelMetadataDetails == null ? 43 : this.modelMetadataDetails.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="inputConfiguration")
        private InputConfiguration inputConfiguration;
        @JsonProperty(value="modelMetadataDetails")
        private List<ModelMetadataDetails> modelMetadataDetails;
        @JsonProperty(value="outputLocation")
        private ObjectPrefixOutputLocation outputLocation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder inputConfiguration(InputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            this.__explicitlySet__.add("inputConfiguration");
            return this;
        }

        public Builder modelMetadataDetails(List<ModelMetadataDetails> modelMetadataDetails) {
            this.modelMetadataDetails = modelMetadataDetails;
            this.__explicitlySet__.add("modelMetadataDetails");
            return this;
        }

        public Builder outputLocation(ObjectPrefixOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public CreateJobDetails build() {
            CreateJobDetails model = new CreateJobDetails(this.displayName, this.description, this.compartmentId, this.inputLocation, this.inputConfiguration, this.modelMetadataDetails, this.outputLocation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateJobDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("inputConfiguration")) {
                this.inputConfiguration(model.getInputConfiguration());
            }
            if (model.wasPropertyExplicitlySet("modelMetadataDetails")) {
                this.modelMetadataDetails(model.getModelMetadataDetails());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            return this;
        }
    }
}

