/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.ConfusionMatrixDetails;
import com.oracle.bmc.ailanguage.model.EntityMetrics;
import com.oracle.bmc.ailanguage.model.EvaluationResults;
import com.oracle.bmc.ailanguage.model.NamedEntityRecognitionModelMetrics;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class NamedEntityRecognitionEvaluationResults
extends EvaluationResults {
    @JsonProperty(value="metrics")
    private final NamedEntityRecognitionModelMetrics metrics;
    @JsonProperty(value="entityMetrics")
    private final List<EntityMetrics> entityMetrics;
    @JsonProperty(value="confusionMatrix")
    private final Map<String, ConfusionMatrixDetails> confusionMatrix;
    @JsonProperty(value="labels")
    private final List<String> labels;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NamedEntityRecognitionEvaluationResults(NamedEntityRecognitionModelMetrics metrics, List<EntityMetrics> entityMetrics, Map<String, ConfusionMatrixDetails> confusionMatrix, List<String> labels) {
        this.metrics = metrics;
        this.entityMetrics = entityMetrics;
        this.confusionMatrix = confusionMatrix;
        this.labels = labels;
    }

    public NamedEntityRecognitionModelMetrics getMetrics() {
        return this.metrics;
    }

    public List<EntityMetrics> getEntityMetrics() {
        return this.entityMetrics;
    }

    public Map<String, ConfusionMatrixDetails> getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NamedEntityRecognitionEvaluationResults(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", metrics=").append(String.valueOf((Object)this.metrics));
        sb.append(", entityMetrics=").append(String.valueOf(this.entityMetrics));
        sb.append(", confusionMatrix=").append(String.valueOf(this.confusionMatrix));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedEntityRecognitionEvaluationResults)) {
            return false;
        }
        NamedEntityRecognitionEvaluationResults other = (NamedEntityRecognitionEvaluationResults)((Object)o);
        return Objects.equals((Object)this.metrics, (Object)other.metrics) && Objects.equals(this.entityMetrics, other.entityMetrics) && Objects.equals(this.confusionMatrix, other.confusionMatrix) && Objects.equals(this.labels, other.labels) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.entityMetrics == null ? 43 : this.entityMetrics.hashCode());
        result = result * 59 + (this.confusionMatrix == null ? 43 : this.confusionMatrix.hashCode());
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metrics")
        private NamedEntityRecognitionModelMetrics metrics;
        @JsonProperty(value="entityMetrics")
        private List<EntityMetrics> entityMetrics;
        @JsonProperty(value="confusionMatrix")
        private Map<String, ConfusionMatrixDetails> confusionMatrix;
        @JsonProperty(value="labels")
        private List<String> labels;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metrics(NamedEntityRecognitionModelMetrics metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder entityMetrics(List<EntityMetrics> entityMetrics) {
            this.entityMetrics = entityMetrics;
            this.__explicitlySet__.add("entityMetrics");
            return this;
        }

        public Builder confusionMatrix(Map<String, ConfusionMatrixDetails> confusionMatrix) {
            this.confusionMatrix = confusionMatrix;
            this.__explicitlySet__.add("confusionMatrix");
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public NamedEntityRecognitionEvaluationResults build() {
            NamedEntityRecognitionEvaluationResults model = new NamedEntityRecognitionEvaluationResults(this.metrics, this.entityMetrics, this.confusionMatrix, this.labels);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NamedEntityRecognitionEvaluationResults model) {
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("entityMetrics")) {
                this.entityMetrics(model.getEntityMetrics());
            }
            if (model.wasPropertyExplicitlySet("confusionMatrix")) {
                this.confusionMatrix(model.getConfusionMatrix());
            }
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            return this;
        }
    }
}

