/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aispeech.model.TranscriptionSettings;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TranscriptionModelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="domain")
    private final Domain domain;
    @JsonProperty(value="languageCode")
    private final LanguageCode languageCode;
    @JsonProperty(value="transcriptionSettings")
    private final TranscriptionSettings transcriptionSettings;

    @Deprecated
    @ConstructorProperties(value={"modelType", "domain", "languageCode", "transcriptionSettings"})
    public TranscriptionModelDetails(String modelType, Domain domain, LanguageCode languageCode, TranscriptionSettings transcriptionSettings) {
        this.modelType = modelType;
        this.domain = domain;
        this.languageCode = languageCode;
        this.transcriptionSettings = transcriptionSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelType() {
        return this.modelType;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public LanguageCode getLanguageCode() {
        return this.languageCode;
    }

    public TranscriptionSettings getTranscriptionSettings() {
        return this.transcriptionSettings;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TranscriptionModelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("modelType=").append(String.valueOf(this.modelType));
        sb.append(", domain=").append(String.valueOf((Object)this.domain));
        sb.append(", languageCode=").append(String.valueOf((Object)this.languageCode));
        sb.append(", transcriptionSettings=").append(String.valueOf((Object)this.transcriptionSettings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranscriptionModelDetails)) {
            return false;
        }
        TranscriptionModelDetails other = (TranscriptionModelDetails)((Object)o);
        return Objects.equals(this.modelType, other.modelType) && Objects.equals((Object)this.domain, (Object)other.domain) && Objects.equals((Object)this.languageCode, (Object)other.languageCode) && Objects.equals((Object)this.transcriptionSettings, (Object)other.transcriptionSettings) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + (this.transcriptionSettings == null ? 43 : this.transcriptionSettings.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LanguageCode implements BmcEnum
    {
        EnUs("en-US"),
        EsEs("es-ES"),
        PtBr("pt-BR"),
        EnGb("en-GB"),
        EnAu("en-AU"),
        EnIn("en-IN"),
        HiIn("hi-IN"),
        FrFr("fr-FR"),
        DeDe("de-DE"),
        ItIt("it-IT"),
        Af("af"),
        Ar("ar"),
        Az("az"),
        Be("be"),
        Bg("bg"),
        Bs("bs"),
        Ca("ca"),
        Cs("cs"),
        Cy("cy"),
        Da("da"),
        De("de"),
        El("el"),
        En("en"),
        Es("es"),
        Et("et"),
        Fa("fa"),
        Fi("fi"),
        Fr("fr"),
        Gl("gl"),
        He("he"),
        Hi("hi"),
        Hr("hr"),
        Hu("hu"),
        Hy("hy"),
        Id("id"),
        Is("is"),
        It("it"),
        Ja("ja"),
        Kk("kk"),
        Kn("kn"),
        Ko("ko"),
        Lt("lt"),
        Lv("lv"),
        Mi("mi"),
        Mk("mk"),
        Mr("mr"),
        Ms("ms"),
        Ne("ne"),
        Nl("nl"),
        No("no"),
        Pl("pl"),
        Pt("pt"),
        Ro("ro"),
        Ru("ru"),
        Sk("sk"),
        Sl("sl"),
        Sr("sr"),
        Sv("sv"),
        Sw("sw"),
        Ta("ta"),
        Th("th"),
        Tl("tl"),
        Tr("tr"),
        Uk("uk"),
        Ur("ur"),
        Vi("vi"),
        Zh("zh"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LanguageCode> map;

        private LanguageCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LanguageCode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LanguageCode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LanguageCode.class);
            map = new HashMap<String, LanguageCode>();
            for (LanguageCode v : LanguageCode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Domain implements BmcEnum
    {
        Generic("GENERIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Domain> map;

        private Domain(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Domain create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Domain', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Domain.class);
            map = new HashMap<String, Domain>();
            for (Domain v : Domain.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="domain")
        private Domain domain;
        @JsonProperty(value="languageCode")
        private LanguageCode languageCode;
        @JsonProperty(value="transcriptionSettings")
        private TranscriptionSettings transcriptionSettings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder domain(Domain domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder languageCode(LanguageCode languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public Builder transcriptionSettings(TranscriptionSettings transcriptionSettings) {
            this.transcriptionSettings = transcriptionSettings;
            this.__explicitlySet__.add("transcriptionSettings");
            return this;
        }

        public TranscriptionModelDetails build() {
            TranscriptionModelDetails model = new TranscriptionModelDetails(this.modelType, this.domain, this.languageCode, this.transcriptionSettings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TranscriptionModelDetails model) {
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            if (model.wasPropertyExplicitlySet("transcriptionSettings")) {
                this.transcriptionSettings(model.getTranscriptionSettings());
            }
            return this;
        }
    }
}

