/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.DocumentFeature;
import com.oracle.bmc.aivision.model.DocumentLanguage;
import com.oracle.bmc.aivision.model.DocumentType;
import com.oracle.bmc.aivision.model.InputLocation;
import com.oracle.bmc.aivision.model.OutputLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDocumentJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="features")
    private final List<DocumentFeature> features;
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="language")
    private final DocumentLanguage language;
    @JsonProperty(value="documentType")
    private final DocumentType documentType;
    @JsonProperty(value="isZipOutputEnabled")
    private final Boolean isZipOutputEnabled;

    @Deprecated
    @ConstructorProperties(value={"inputLocation", "features", "outputLocation", "compartmentId", "displayName", "language", "documentType", "isZipOutputEnabled"})
    public CreateDocumentJobDetails(InputLocation inputLocation, List<DocumentFeature> features, OutputLocation outputLocation, String compartmentId, String displayName, DocumentLanguage language, DocumentType documentType, Boolean isZipOutputEnabled) {
        this.inputLocation = inputLocation;
        this.features = features;
        this.outputLocation = outputLocation;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.language = language;
        this.documentType = documentType;
        this.isZipOutputEnabled = isZipOutputEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public List<DocumentFeature> getFeatures() {
        return this.features;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DocumentLanguage getLanguage() {
        return this.language;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public Boolean getIsZipOutputEnabled() {
        return this.isZipOutputEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDocumentJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", features=").append(String.valueOf(this.features));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", language=").append(String.valueOf((Object)this.language));
        sb.append(", documentType=").append(String.valueOf((Object)this.documentType));
        sb.append(", isZipOutputEnabled=").append(String.valueOf(this.isZipOutputEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDocumentJobDetails)) {
            return false;
        }
        CreateDocumentJobDetails other = (CreateDocumentJobDetails)((Object)o);
        return Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals(this.features, other.features) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.language, (Object)other.language) && Objects.equals((Object)this.documentType, (Object)other.documentType) && Objects.equals(this.isZipOutputEnabled, other.isZipOutputEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.features == null ? 43 : this.features.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        result = result * 59 + (this.documentType == null ? 43 : this.documentType.hashCode());
        result = result * 59 + (this.isZipOutputEnabled == null ? 43 : this.isZipOutputEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="features")
        private List<DocumentFeature> features;
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="language")
        private DocumentLanguage language;
        @JsonProperty(value="documentType")
        private DocumentType documentType;
        @JsonProperty(value="isZipOutputEnabled")
        private Boolean isZipOutputEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder features(List<DocumentFeature> features) {
            this.features = features;
            this.__explicitlySet__.add("features");
            return this;
        }

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder language(DocumentLanguage language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public Builder documentType(DocumentType documentType) {
            this.documentType = documentType;
            this.__explicitlySet__.add("documentType");
            return this;
        }

        public Builder isZipOutputEnabled(Boolean isZipOutputEnabled) {
            this.isZipOutputEnabled = isZipOutputEnabled;
            this.__explicitlySet__.add("isZipOutputEnabled");
            return this;
        }

        public CreateDocumentJobDetails build() {
            CreateDocumentJobDetails model = new CreateDocumentJobDetails(this.inputLocation, this.features, this.outputLocation, this.compartmentId, this.displayName, this.language, this.documentType, this.isZipOutputEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDocumentJobDetails model) {
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("features")) {
                this.features(model.getFeatures());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            if (model.wasPropertyExplicitlySet("documentType")) {
                this.documentType(model.getDocumentType());
            }
            if (model.wasPropertyExplicitlySet("isZipOutputEnabled")) {
                this.isZipOutputEnabled(model.getIsZipOutputEnabled());
            }
            return this;
        }
    }
}

