/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.ImageFeature;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="featureType")
@JsonFilter(value="explicitlySetFilter")
public final class FaceDetectionFeature
extends ImageFeature {
    @JsonProperty(value="maxResults")
    private final Integer maxResults;
    @JsonProperty(value="shouldReturnLandmarks")
    private final Boolean shouldReturnLandmarks;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FaceDetectionFeature(Integer maxResults, Boolean shouldReturnLandmarks) {
        this.maxResults = maxResults;
        this.shouldReturnLandmarks = shouldReturnLandmarks;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Boolean getShouldReturnLandmarks() {
        return this.shouldReturnLandmarks;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FaceDetectionFeature(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", maxResults=").append(String.valueOf(this.maxResults));
        sb.append(", shouldReturnLandmarks=").append(String.valueOf(this.shouldReturnLandmarks));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FaceDetectionFeature)) {
            return false;
        }
        FaceDetectionFeature other = (FaceDetectionFeature)((Object)o);
        return Objects.equals(this.maxResults, other.maxResults) && Objects.equals(this.shouldReturnLandmarks, other.shouldReturnLandmarks) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maxResults == null ? 43 : this.maxResults.hashCode());
        result = result * 59 + (this.shouldReturnLandmarks == null ? 43 : this.shouldReturnLandmarks.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxResults")
        private Integer maxResults;
        @JsonProperty(value="shouldReturnLandmarks")
        private Boolean shouldReturnLandmarks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            this.__explicitlySet__.add("maxResults");
            return this;
        }

        public Builder shouldReturnLandmarks(Boolean shouldReturnLandmarks) {
            this.shouldReturnLandmarks = shouldReturnLandmarks;
            this.__explicitlySet__.add("shouldReturnLandmarks");
            return this;
        }

        public FaceDetectionFeature build() {
            FaceDetectionFeature model = new FaceDetectionFeature(this.maxResults, this.shouldReturnLandmarks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FaceDetectionFeature model) {
            if (model.wasPropertyExplicitlySet("maxResults")) {
                this.maxResults(model.getMaxResults());
            }
            if (model.wasPropertyExplicitlySet("shouldReturnLandmarks")) {
                this.shouldReturnLandmarks(model.getShouldReturnLandmarks());
            }
            return this;
        }
    }
}

