/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.ImageFeature;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="featureType")
@JsonFilter(value="explicitlySetFilter")
public final class ImageObjectDetectionFeature
extends ImageFeature {
    @JsonProperty(value="maxResults")
    private final Integer maxResults;
    @JsonProperty(value="modelId")
    private final String modelId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImageObjectDetectionFeature(Integer maxResults, String modelId) {
        this.maxResults = maxResults;
        this.modelId = modelId;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageObjectDetectionFeature(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", maxResults=").append(String.valueOf(this.maxResults));
        sb.append(", modelId=").append(String.valueOf(this.modelId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageObjectDetectionFeature)) {
            return false;
        }
        ImageObjectDetectionFeature other = (ImageObjectDetectionFeature)((Object)o);
        return Objects.equals(this.maxResults, other.maxResults) && Objects.equals(this.modelId, other.modelId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maxResults == null ? 43 : this.maxResults.hashCode());
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxResults")
        private Integer maxResults;
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            this.__explicitlySet__.add("maxResults");
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public ImageObjectDetectionFeature build() {
            ImageObjectDetectionFeature model = new ImageObjectDetectionFeature(this.maxResults, this.modelId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageObjectDetectionFeature model) {
            if (model.wasPropertyExplicitlySet("maxResults")) {
                this.maxResults(model.getMaxResults());
            }
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            return this;
        }
    }
}

