/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aivision.AIServiceVisionAsync;
import com.oracle.bmc.aivision.model.AnalyzeDocumentResult;
import com.oracle.bmc.aivision.model.AnalyzeImageResult;
import com.oracle.bmc.aivision.model.DocumentJob;
import com.oracle.bmc.aivision.model.ImageJob;
import com.oracle.bmc.aivision.model.Model;
import com.oracle.bmc.aivision.model.ModelCollection;
import com.oracle.bmc.aivision.model.Project;
import com.oracle.bmc.aivision.model.ProjectCollection;
import com.oracle.bmc.aivision.model.WorkRequest;
import com.oracle.bmc.aivision.model.WorkRequestErrorCollection;
import com.oracle.bmc.aivision.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.aivision.model.WorkRequestSummaryCollection;
import com.oracle.bmc.aivision.requests.AnalyzeDocumentRequest;
import com.oracle.bmc.aivision.requests.AnalyzeImageRequest;
import com.oracle.bmc.aivision.requests.CancelDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CancelImageJobRequest;
import com.oracle.bmc.aivision.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aivision.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aivision.requests.CreateDocumentJobRequest;
import com.oracle.bmc.aivision.requests.CreateImageJobRequest;
import com.oracle.bmc.aivision.requests.CreateModelRequest;
import com.oracle.bmc.aivision.requests.CreateProjectRequest;
import com.oracle.bmc.aivision.requests.DeleteModelRequest;
import com.oracle.bmc.aivision.requests.DeleteProjectRequest;
import com.oracle.bmc.aivision.requests.GetDocumentJobRequest;
import com.oracle.bmc.aivision.requests.GetImageJobRequest;
import com.oracle.bmc.aivision.requests.GetModelRequest;
import com.oracle.bmc.aivision.requests.GetProjectRequest;
import com.oracle.bmc.aivision.requests.GetWorkRequestRequest;
import com.oracle.bmc.aivision.requests.ListModelsRequest;
import com.oracle.bmc.aivision.requests.ListProjectsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aivision.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aivision.requests.UpdateModelRequest;
import com.oracle.bmc.aivision.requests.UpdateProjectRequest;
import com.oracle.bmc.aivision.responses.AnalyzeDocumentResponse;
import com.oracle.bmc.aivision.responses.AnalyzeImageResponse;
import com.oracle.bmc.aivision.responses.CancelDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CancelImageJobResponse;
import com.oracle.bmc.aivision.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aivision.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aivision.responses.CreateDocumentJobResponse;
import com.oracle.bmc.aivision.responses.CreateImageJobResponse;
import com.oracle.bmc.aivision.responses.CreateModelResponse;
import com.oracle.bmc.aivision.responses.CreateProjectResponse;
import com.oracle.bmc.aivision.responses.DeleteModelResponse;
import com.oracle.bmc.aivision.responses.DeleteProjectResponse;
import com.oracle.bmc.aivision.responses.GetDocumentJobResponse;
import com.oracle.bmc.aivision.responses.GetImageJobResponse;
import com.oracle.bmc.aivision.responses.GetModelResponse;
import com.oracle.bmc.aivision.responses.GetProjectResponse;
import com.oracle.bmc.aivision.responses.GetWorkRequestResponse;
import com.oracle.bmc.aivision.responses.ListModelsResponse;
import com.oracle.bmc.aivision.responses.ListProjectsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aivision.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aivision.responses.UpdateModelResponse;
import com.oracle.bmc.aivision.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceVisionAsyncClient
extends BaseAsyncClient
implements AIServiceVisionAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEVISION").serviceEndpointPrefix("").serviceEndpointTemplate("https://vision.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceVisionAsyncClient.class);

    AIServiceVisionAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AnalyzeDocumentResponse> analyzeDocument(AnalyzeDocumentRequest request, AsyncHandler<AnalyzeDocumentRequest, AnalyzeDocumentResponse> handler) {
        Objects.requireNonNull(request.getAnalyzeDocumentDetails(), "analyzeDocumentDetails is required");
        return this.clientCall(request, AnalyzeDocumentResponse::builder).logger(LOG, "analyzeDocument").serviceDetails("AIServiceVision", "AnalyzeDocument", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/AnalyzeDocumentResult/AnalyzeDocument").method(Method.POST).requestBuilder(AnalyzeDocumentRequest::builder).basePath("/20220125").appendPathParam("actions").appendPathParam("analyzeDocument").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeDocumentResult.class, AnalyzeDocumentResponse.Builder::analyzeDocumentResult).handleResponseHeaderString("etag", AnalyzeDocumentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeDocumentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AnalyzeImageResponse> analyzeImage(AnalyzeImageRequest request, AsyncHandler<AnalyzeImageRequest, AnalyzeImageResponse> handler) {
        Objects.requireNonNull(request.getAnalyzeImageDetails(), "analyzeImageDetails is required");
        return this.clientCall(request, AnalyzeImageResponse::builder).logger(LOG, "analyzeImage").serviceDetails("AIServiceVision", "AnalyzeImage", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/AnalyzeImageResult/AnalyzeImage").method(Method.POST).requestBuilder(AnalyzeImageRequest::builder).basePath("/20220125").appendPathParam("actions").appendPathParam("analyzeImage").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeImageResult.class, AnalyzeImageResponse.Builder::analyzeImageResult).handleResponseHeaderString("etag", AnalyzeImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelDocumentJobResponse> cancelDocumentJob(CancelDocumentJobRequest request, AsyncHandler<CancelDocumentJobRequest, CancelDocumentJobResponse> handler) {
        Validate.notBlank((String)request.getDocumentJobId(), (String)"documentJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelDocumentJobResponse::builder).logger(LOG, "cancelDocumentJob").serviceDetails("AIServiceVision", "CancelDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/CancelDocumentJob").method(Method.POST).requestBuilder(CancelDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").appendPathParam(request.getDocumentJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelDocumentJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelImageJobResponse> cancelImageJob(CancelImageJobRequest request, AsyncHandler<CancelImageJobRequest, CancelImageJobResponse> handler) {
        Validate.notBlank((String)request.getImageJobId(), (String)"imageJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelImageJobResponse::builder).logger(LOG, "cancelImageJob").serviceDetails("AIServiceVision", "CancelImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/CancelImageJob").method(Method.POST).requestBuilder(CancelImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").appendPathParam(request.getImageJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelImageJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("AIServiceVision", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AIServiceVision", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AIServiceVision", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDocumentJobResponse> createDocumentJob(CreateDocumentJobRequest request, AsyncHandler<CreateDocumentJobRequest, CreateDocumentJobResponse> handler) {
        Objects.requireNonNull(request.getCreateDocumentJobDetails(), "createDocumentJobDetails is required");
        return this.clientCall(request, CreateDocumentJobResponse::builder).logger(LOG, "createDocumentJob").serviceDetails("AIServiceVision", "CreateDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/CreateDocumentJob").method(Method.POST).requestBuilder(CreateDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DocumentJob.class, CreateDocumentJobResponse.Builder::documentJob).handleResponseHeaderString("etag", CreateDocumentJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDocumentJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateImageJobResponse> createImageJob(CreateImageJobRequest request, AsyncHandler<CreateImageJobRequest, CreateImageJobResponse> handler) {
        Objects.requireNonNull(request.getCreateImageJobDetails(), "createImageJobDetails is required");
        return this.clientCall(request, CreateImageJobResponse::builder).logger(LOG, "createImageJob").serviceDetails("AIServiceVision", "CreateImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/CreateImageJob").method(Method.POST).requestBuilder(CreateImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ImageJob.class, CreateImageJobResponse.Builder::imageJob).handleResponseHeaderString("etag", CreateImageJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateImageJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AIServiceVision", "CreateModel", "").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20220125").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AIServiceVision", "CreateProject", "").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20220125").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AIServiceVision", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AIServiceVision", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDocumentJobResponse> getDocumentJob(GetDocumentJobRequest request, AsyncHandler<GetDocumentJobRequest, GetDocumentJobResponse> handler) {
        Validate.notBlank((String)request.getDocumentJobId(), (String)"documentJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDocumentJobResponse::builder).logger(LOG, "getDocumentJob").serviceDetails("AIServiceVision", "GetDocumentJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/DocumentJob/GetDocumentJob").method(Method.GET).requestBuilder(GetDocumentJobRequest::builder).basePath("/20220125").appendPathParam("documentJobs").appendPathParam(request.getDocumentJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DocumentJob.class, GetDocumentJobResponse.Builder::documentJob).handleResponseHeaderString("etag", GetDocumentJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDocumentJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetImageJobResponse> getImageJob(GetImageJobRequest request, AsyncHandler<GetImageJobRequest, GetImageJobResponse> handler) {
        Validate.notBlank((String)request.getImageJobId(), (String)"imageJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetImageJobResponse::builder).logger(LOG, "getImageJob").serviceDetails("AIServiceVision", "GetImageJob", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ImageJob/GetImageJob").method(Method.GET).requestBuilder(GetImageJobRequest::builder).basePath("/20220125").appendPathParam("imageJobs").appendPathParam(request.getImageJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ImageJob.class, GetImageJobResponse.Builder::imageJob).handleResponseHeaderString("etag", GetImageJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetImageJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AIServiceVision", "GetModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AIServiceVision", "GetProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AIServiceVision", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        return this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AIServiceVision", "ListModels", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ModelCollection/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20220125").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        return this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AIServiceVision", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/ProjectCollection/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20220125").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AIServiceVision", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AIServiceVision", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AIServiceVision", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AIServiceVision", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20220125").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AIServiceVision", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/vision/20220125/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20220125").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceVisionAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceVisionAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceVisionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceVisionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceVisionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceVisionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceVisionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceVisionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceVisionAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "aivision";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"aivision");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceVisionAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceVisionAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

