/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.DetectedDocumentType;
import com.oracle.bmc.aivision.model.DetectedLanguage;
import com.oracle.bmc.aivision.model.DocumentMetadata;
import com.oracle.bmc.aivision.model.Page;
import com.oracle.bmc.aivision.model.ProcessingError;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnalyzeDocumentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="documentMetadata")
    private final DocumentMetadata documentMetadata;
    @JsonProperty(value="pages")
    private final List<Page> pages;
    @JsonProperty(value="detectedDocumentTypes")
    private final List<DetectedDocumentType> detectedDocumentTypes;
    @JsonProperty(value="detectedLanguages")
    private final List<DetectedLanguage> detectedLanguages;
    @JsonProperty(value="documentClassificationModelVersion")
    private final String documentClassificationModelVersion;
    @JsonProperty(value="languageClassificationModelVersion")
    private final String languageClassificationModelVersion;
    @JsonProperty(value="textDetectionModelVersion")
    private final String textDetectionModelVersion;
    @JsonProperty(value="keyValueDetectionModelVersion")
    private final String keyValueDetectionModelVersion;
    @JsonProperty(value="tableDetectionModelVersion")
    private final String tableDetectionModelVersion;
    @JsonProperty(value="errors")
    private final List<ProcessingError> errors;
    @JsonProperty(value="searchablePdf")
    private final byte[] searchablePdf;

    @Deprecated
    @ConstructorProperties(value={"documentMetadata", "pages", "detectedDocumentTypes", "detectedLanguages", "documentClassificationModelVersion", "languageClassificationModelVersion", "textDetectionModelVersion", "keyValueDetectionModelVersion", "tableDetectionModelVersion", "errors", "searchablePdf"})
    public AnalyzeDocumentResult(DocumentMetadata documentMetadata, List<Page> pages, List<DetectedDocumentType> detectedDocumentTypes, List<DetectedLanguage> detectedLanguages, String documentClassificationModelVersion, String languageClassificationModelVersion, String textDetectionModelVersion, String keyValueDetectionModelVersion, String tableDetectionModelVersion, List<ProcessingError> errors, byte[] searchablePdf) {
        this.documentMetadata = documentMetadata;
        this.pages = pages;
        this.detectedDocumentTypes = detectedDocumentTypes;
        this.detectedLanguages = detectedLanguages;
        this.documentClassificationModelVersion = documentClassificationModelVersion;
        this.languageClassificationModelVersion = languageClassificationModelVersion;
        this.textDetectionModelVersion = textDetectionModelVersion;
        this.keyValueDetectionModelVersion = keyValueDetectionModelVersion;
        this.tableDetectionModelVersion = tableDetectionModelVersion;
        this.errors = errors;
        this.searchablePdf = searchablePdf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public List<DetectedDocumentType> getDetectedDocumentTypes() {
        return this.detectedDocumentTypes;
    }

    public List<DetectedLanguage> getDetectedLanguages() {
        return this.detectedLanguages;
    }

    public String getDocumentClassificationModelVersion() {
        return this.documentClassificationModelVersion;
    }

    public String getLanguageClassificationModelVersion() {
        return this.languageClassificationModelVersion;
    }

    public String getTextDetectionModelVersion() {
        return this.textDetectionModelVersion;
    }

    public String getKeyValueDetectionModelVersion() {
        return this.keyValueDetectionModelVersion;
    }

    public String getTableDetectionModelVersion() {
        return this.tableDetectionModelVersion;
    }

    public List<ProcessingError> getErrors() {
        return this.errors;
    }

    public byte[] getSearchablePdf() {
        return this.searchablePdf;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalyzeDocumentResult(");
        sb.append("super=").append(super.toString());
        sb.append("documentMetadata=").append(String.valueOf((Object)this.documentMetadata));
        sb.append(", pages=").append(String.valueOf(this.pages));
        sb.append(", detectedDocumentTypes=").append(String.valueOf(this.detectedDocumentTypes));
        sb.append(", detectedLanguages=").append(String.valueOf(this.detectedLanguages));
        sb.append(", documentClassificationModelVersion=").append(String.valueOf(this.documentClassificationModelVersion));
        sb.append(", languageClassificationModelVersion=").append(String.valueOf(this.languageClassificationModelVersion));
        sb.append(", textDetectionModelVersion=").append(String.valueOf(this.textDetectionModelVersion));
        sb.append(", keyValueDetectionModelVersion=").append(String.valueOf(this.keyValueDetectionModelVersion));
        sb.append(", tableDetectionModelVersion=").append(String.valueOf(this.tableDetectionModelVersion));
        sb.append(", errors=").append(String.valueOf(this.errors));
        sb.append(", searchablePdf=").append(includeByteArrayContents ? Arrays.toString(this.searchablePdf) : String.valueOf(this.searchablePdf) + (this.searchablePdf != null ? " (byte[" + this.searchablePdf.length + "])" : ""));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzeDocumentResult)) {
            return false;
        }
        AnalyzeDocumentResult other = (AnalyzeDocumentResult)((Object)o);
        return Objects.equals((Object)this.documentMetadata, (Object)other.documentMetadata) && Objects.equals(this.pages, other.pages) && Objects.equals(this.detectedDocumentTypes, other.detectedDocumentTypes) && Objects.equals(this.detectedLanguages, other.detectedLanguages) && Objects.equals(this.documentClassificationModelVersion, other.documentClassificationModelVersion) && Objects.equals(this.languageClassificationModelVersion, other.languageClassificationModelVersion) && Objects.equals(this.textDetectionModelVersion, other.textDetectionModelVersion) && Objects.equals(this.keyValueDetectionModelVersion, other.keyValueDetectionModelVersion) && Objects.equals(this.tableDetectionModelVersion, other.tableDetectionModelVersion) && Objects.equals(this.errors, other.errors) && Arrays.equals(this.searchablePdf, other.searchablePdf) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.documentMetadata == null ? 43 : this.documentMetadata.hashCode());
        result = result * 59 + (this.pages == null ? 43 : this.pages.hashCode());
        result = result * 59 + (this.detectedDocumentTypes == null ? 43 : this.detectedDocumentTypes.hashCode());
        result = result * 59 + (this.detectedLanguages == null ? 43 : this.detectedLanguages.hashCode());
        result = result * 59 + (this.documentClassificationModelVersion == null ? 43 : this.documentClassificationModelVersion.hashCode());
        result = result * 59 + (this.languageClassificationModelVersion == null ? 43 : this.languageClassificationModelVersion.hashCode());
        result = result * 59 + (this.textDetectionModelVersion == null ? 43 : this.textDetectionModelVersion.hashCode());
        result = result * 59 + (this.keyValueDetectionModelVersion == null ? 43 : this.keyValueDetectionModelVersion.hashCode());
        result = result * 59 + (this.tableDetectionModelVersion == null ? 43 : this.tableDetectionModelVersion.hashCode());
        result = result * 59 + (this.errors == null ? 43 : this.errors.hashCode());
        result = result * 59 + Arrays.hashCode(this.searchablePdf);
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="documentMetadata")
        private DocumentMetadata documentMetadata;
        @JsonProperty(value="pages")
        private List<Page> pages;
        @JsonProperty(value="detectedDocumentTypes")
        private List<DetectedDocumentType> detectedDocumentTypes;
        @JsonProperty(value="detectedLanguages")
        private List<DetectedLanguage> detectedLanguages;
        @JsonProperty(value="documentClassificationModelVersion")
        private String documentClassificationModelVersion;
        @JsonProperty(value="languageClassificationModelVersion")
        private String languageClassificationModelVersion;
        @JsonProperty(value="textDetectionModelVersion")
        private String textDetectionModelVersion;
        @JsonProperty(value="keyValueDetectionModelVersion")
        private String keyValueDetectionModelVersion;
        @JsonProperty(value="tableDetectionModelVersion")
        private String tableDetectionModelVersion;
        @JsonProperty(value="errors")
        private List<ProcessingError> errors;
        @JsonProperty(value="searchablePdf")
        private byte[] searchablePdf;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            this.__explicitlySet__.add("documentMetadata");
            return this;
        }

        public Builder pages(List<Page> pages) {
            this.pages = pages;
            this.__explicitlySet__.add("pages");
            return this;
        }

        public Builder detectedDocumentTypes(List<DetectedDocumentType> detectedDocumentTypes) {
            this.detectedDocumentTypes = detectedDocumentTypes;
            this.__explicitlySet__.add("detectedDocumentTypes");
            return this;
        }

        public Builder detectedLanguages(List<DetectedLanguage> detectedLanguages) {
            this.detectedLanguages = detectedLanguages;
            this.__explicitlySet__.add("detectedLanguages");
            return this;
        }

        public Builder documentClassificationModelVersion(String documentClassificationModelVersion) {
            this.documentClassificationModelVersion = documentClassificationModelVersion;
            this.__explicitlySet__.add("documentClassificationModelVersion");
            return this;
        }

        public Builder languageClassificationModelVersion(String languageClassificationModelVersion) {
            this.languageClassificationModelVersion = languageClassificationModelVersion;
            this.__explicitlySet__.add("languageClassificationModelVersion");
            return this;
        }

        public Builder textDetectionModelVersion(String textDetectionModelVersion) {
            this.textDetectionModelVersion = textDetectionModelVersion;
            this.__explicitlySet__.add("textDetectionModelVersion");
            return this;
        }

        public Builder keyValueDetectionModelVersion(String keyValueDetectionModelVersion) {
            this.keyValueDetectionModelVersion = keyValueDetectionModelVersion;
            this.__explicitlySet__.add("keyValueDetectionModelVersion");
            return this;
        }

        public Builder tableDetectionModelVersion(String tableDetectionModelVersion) {
            this.tableDetectionModelVersion = tableDetectionModelVersion;
            this.__explicitlySet__.add("tableDetectionModelVersion");
            return this;
        }

        public Builder errors(List<ProcessingError> errors) {
            this.errors = errors;
            this.__explicitlySet__.add("errors");
            return this;
        }

        public Builder searchablePdf(byte[] searchablePdf) {
            this.searchablePdf = searchablePdf;
            this.__explicitlySet__.add("searchablePdf");
            return this;
        }

        public AnalyzeDocumentResult build() {
            AnalyzeDocumentResult model = new AnalyzeDocumentResult(this.documentMetadata, this.pages, this.detectedDocumentTypes, this.detectedLanguages, this.documentClassificationModelVersion, this.languageClassificationModelVersion, this.textDetectionModelVersion, this.keyValueDetectionModelVersion, this.tableDetectionModelVersion, this.errors, this.searchablePdf);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnalyzeDocumentResult model) {
            if (model.wasPropertyExplicitlySet("documentMetadata")) {
                this.documentMetadata(model.getDocumentMetadata());
            }
            if (model.wasPropertyExplicitlySet("pages")) {
                this.pages(model.getPages());
            }
            if (model.wasPropertyExplicitlySet("detectedDocumentTypes")) {
                this.detectedDocumentTypes(model.getDetectedDocumentTypes());
            }
            if (model.wasPropertyExplicitlySet("detectedLanguages")) {
                this.detectedLanguages(model.getDetectedLanguages());
            }
            if (model.wasPropertyExplicitlySet("documentClassificationModelVersion")) {
                this.documentClassificationModelVersion(model.getDocumentClassificationModelVersion());
            }
            if (model.wasPropertyExplicitlySet("languageClassificationModelVersion")) {
                this.languageClassificationModelVersion(model.getLanguageClassificationModelVersion());
            }
            if (model.wasPropertyExplicitlySet("textDetectionModelVersion")) {
                this.textDetectionModelVersion(model.getTextDetectionModelVersion());
            }
            if (model.wasPropertyExplicitlySet("keyValueDetectionModelVersion")) {
                this.keyValueDetectionModelVersion(model.getKeyValueDetectionModelVersion());
            }
            if (model.wasPropertyExplicitlySet("tableDetectionModelVersion")) {
                this.tableDetectionModelVersion(model.getTableDetectionModelVersion());
            }
            if (model.wasPropertyExplicitlySet("errors")) {
                this.errors(model.getErrors());
            }
            if (model.wasPropertyExplicitlySet("searchablePdf")) {
                this.searchablePdf(model.getSearchablePdf());
            }
            return this;
        }
    }
}

