/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aivision.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aivision.model.BoundingPolygon;
import com.oracle.bmc.aivision.model.Landmark;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Face
extends ExplicitlySetBmcModel {
    @JsonProperty(value="confidence")
    private final Float confidence;
    @JsonProperty(value="boundingPolygon")
    private final BoundingPolygon boundingPolygon;
    @JsonProperty(value="qualityScore")
    private final Float qualityScore;
    @JsonProperty(value="landmarks")
    private final List<Landmark> landmarks;

    @Deprecated
    @ConstructorProperties(value={"confidence", "boundingPolygon", "qualityScore", "landmarks"})
    public Face(Float confidence, BoundingPolygon boundingPolygon, Float qualityScore, List<Landmark> landmarks) {
        this.confidence = confidence;
        this.boundingPolygon = boundingPolygon;
        this.qualityScore = qualityScore;
        this.landmarks = landmarks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public BoundingPolygon getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public Float getQualityScore() {
        return this.qualityScore;
    }

    public List<Landmark> getLandmarks() {
        return this.landmarks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Face(");
        sb.append("super=").append(super.toString());
        sb.append("confidence=").append(String.valueOf(this.confidence));
        sb.append(", boundingPolygon=").append(String.valueOf((Object)this.boundingPolygon));
        sb.append(", qualityScore=").append(String.valueOf(this.qualityScore));
        sb.append(", landmarks=").append(String.valueOf(this.landmarks));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Face)) {
            return false;
        }
        Face other = (Face)((Object)o);
        return Objects.equals(this.confidence, other.confidence) && Objects.equals((Object)this.boundingPolygon, (Object)other.boundingPolygon) && Objects.equals(this.qualityScore, other.qualityScore) && Objects.equals(this.landmarks, other.landmarks) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.confidence == null ? 43 : this.confidence.hashCode());
        result = result * 59 + (this.boundingPolygon == null ? 43 : this.boundingPolygon.hashCode());
        result = result * 59 + (this.qualityScore == null ? 43 : this.qualityScore.hashCode());
        result = result * 59 + (this.landmarks == null ? 43 : this.landmarks.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="confidence")
        private Float confidence;
        @JsonProperty(value="boundingPolygon")
        private BoundingPolygon boundingPolygon;
        @JsonProperty(value="qualityScore")
        private Float qualityScore;
        @JsonProperty(value="landmarks")
        private List<Landmark> landmarks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder confidence(Float confidence) {
            this.confidence = confidence;
            this.__explicitlySet__.add("confidence");
            return this;
        }

        public Builder boundingPolygon(BoundingPolygon boundingPolygon) {
            this.boundingPolygon = boundingPolygon;
            this.__explicitlySet__.add("boundingPolygon");
            return this;
        }

        public Builder qualityScore(Float qualityScore) {
            this.qualityScore = qualityScore;
            this.__explicitlySet__.add("qualityScore");
            return this;
        }

        public Builder landmarks(List<Landmark> landmarks) {
            this.landmarks = landmarks;
            this.__explicitlySet__.add("landmarks");
            return this;
        }

        public Face build() {
            Face model = new Face(this.confidence, this.boundingPolygon, this.qualityScore, this.landmarks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Face model) {
            if (model.wasPropertyExplicitlySet("confidence")) {
                this.confidence(model.getConfidence());
            }
            if (model.wasPropertyExplicitlySet("boundingPolygon")) {
                this.boundingPolygon(model.getBoundingPolygon());
            }
            if (model.wasPropertyExplicitlySet("qualityScore")) {
                this.qualityScore(model.getQualityScore());
            }
            if (model.wasPropertyExplicitlySet("landmarks")) {
                this.landmarks(model.getLandmarks());
            }
            return this;
        }
    }
}

