/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.analytics.Analytics;
import com.oracle.bmc.analytics.AnalyticsPaginators;
import com.oracle.bmc.analytics.AnalyticsWaiters;
import com.oracle.bmc.analytics.model.AnalyticsInstance;
import com.oracle.bmc.analytics.model.AnalyticsInstanceSummary;
import com.oracle.bmc.analytics.model.PrivateAccessChannel;
import com.oracle.bmc.analytics.model.WorkRequest;
import com.oracle.bmc.analytics.model.WorkRequestError;
import com.oracle.bmc.analytics.model.WorkRequestLog;
import com.oracle.bmc.analytics.model.WorkRequestSummary;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceCompartmentRequest;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceNetworkEndpointRequest;
import com.oracle.bmc.analytics.requests.CreateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.CreatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.CreateVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.DeletePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.DeleteVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetPrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.requests.ScaleAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.SetKmsKeyRequest;
import com.oracle.bmc.analytics.requests.StartAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StopAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.UpdateVanityUrlRequest;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceCompartmentResponse;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceNetworkEndpointResponse;
import com.oracle.bmc.analytics.responses.CreateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.CreatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.CreateVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.DeletePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.DeleteVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetPrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.analytics.responses.ScaleAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.SetKmsKeyResponse;
import com.oracle.bmc.analytics.responses.StartAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StopAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.UpdateVanityUrlResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsClient
extends BaseSyncClient
implements Analytics {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANALYTICS").serviceEndpointPrefix("").serviceEndpointTemplate("https://analytics.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsClient.class);
    private final AnalyticsWaiters waiters;
    private final AnalyticsPaginators paginators;

    AnalyticsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Analytics-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AnalyticsWaiters(executorService, this);
        this.paginators = new AnalyticsPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeAnalyticsInstanceCompartmentResponse changeAnalyticsInstanceCompartment(ChangeAnalyticsInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCompartmentDetails(), "changeCompartmentDetails is required");
        return (ChangeAnalyticsInstanceCompartmentResponse)this.clientCall(request, ChangeAnalyticsInstanceCompartmentResponse::builder).logger(LOG, "changeAnalyticsInstanceCompartment").serviceDetails("Analytics", "ChangeAnalyticsInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ChangeAnalyticsInstanceCompartment").method(Method.POST).requestBuilder(ChangeAnalyticsInstanceCompartmentRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeAnalyticsInstanceCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeAnalyticsInstanceCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ChangeAnalyticsInstanceNetworkEndpointResponse changeAnalyticsInstanceNetworkEndpoint(ChangeAnalyticsInstanceNetworkEndpointRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAnalyticsInstanceNetworkEndpointDetails(), "changeAnalyticsInstanceNetworkEndpointDetails is required");
        return (ChangeAnalyticsInstanceNetworkEndpointResponse)this.clientCall(request, ChangeAnalyticsInstanceNetworkEndpointResponse::builder).logger(LOG, "changeAnalyticsInstanceNetworkEndpoint").serviceDetails("Analytics", "ChangeAnalyticsInstanceNetworkEndpoint", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ChangeAnalyticsInstanceNetworkEndpoint").method(Method.POST).requestBuilder(ChangeAnalyticsInstanceNetworkEndpointRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("changeNetworkEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeAnalyticsInstanceNetworkEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeAnalyticsInstanceNetworkEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateAnalyticsInstanceResponse createAnalyticsInstance(CreateAnalyticsInstanceRequest request) {
        Objects.requireNonNull(request.getCreateAnalyticsInstanceDetails(), "createAnalyticsInstanceDetails is required");
        return (CreateAnalyticsInstanceResponse)this.clientCall(request, CreateAnalyticsInstanceResponse::builder).logger(LOG, "createAnalyticsInstance").serviceDetails("Analytics", "CreateAnalyticsInstance", "").method(Method.POST).requestBuilder(CreateAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(AnalyticsInstance.class, CreateAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", CreateAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAnalyticsInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateAnalyticsInstanceResponse.Builder::location).callSync();
    }

    @Override
    public CreatePrivateAccessChannelResponse createPrivateAccessChannel(CreatePrivateAccessChannelRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePrivateAccessChannelDetails(), "createPrivateAccessChannelDetails is required");
        return (CreatePrivateAccessChannelResponse)this.clientCall(request, CreatePrivateAccessChannelResponse::builder).logger(LOG, "createPrivateAccessChannel").serviceDetails("Analytics", "CreatePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/CreatePrivateAccessChannel").method(Method.POST).requestBuilder(CreatePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", CreatePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePrivateAccessChannelResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateVanityUrlResponse createVanityUrl(CreateVanityUrlRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateVanityUrlDetails(), "createVanityUrlDetails is required");
        return (CreateVanityUrlResponse)this.clientCall(request, CreateVanityUrlResponse::builder).logger(LOG, "createVanityUrl").serviceDetails("Analytics", "CreateVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/CreateVanityUrl").method(Method.POST).requestBuilder(CreateVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", CreateVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateVanityUrlResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteAnalyticsInstanceResponse deleteAnalyticsInstance(DeleteAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteAnalyticsInstanceResponse)this.clientCall(request, DeleteAnalyticsInstanceResponse::builder).logger(LOG, "deleteAnalyticsInstance").serviceDetails("Analytics", "DeleteAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeleteAnalyticsInstance").method(Method.DELETE).requestBuilder(DeleteAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAnalyticsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeletePrivateAccessChannelResponse deletePrivateAccessChannel(DeletePrivateAccessChannelRequest request) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (DeletePrivateAccessChannelResponse)this.clientCall(request, DeletePrivateAccessChannelResponse::builder).logger(LOG, "deletePrivateAccessChannel").serviceDetails("Analytics", "DeletePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeletePrivateAccessChannel").method(Method.DELETE).requestBuilder(DeletePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeletePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeletePrivateAccessChannelResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteVanityUrlResponse deleteVanityUrl(DeleteVanityUrlRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVanityUrlKey(), (String)"vanityUrlKey must not be blank", (Object[])new Object[0]);
        return (DeleteVanityUrlResponse)this.clientCall(request, DeleteVanityUrlResponse::builder).logger(LOG, "deleteVanityUrl").serviceDetails("Analytics", "DeleteVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/DeleteVanityUrl").method(Method.DELETE).requestBuilder(DeleteVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").appendPathParam(request.getVanityUrlKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteVanityUrlResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteWorkRequestResponse)this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("Analytics", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAnalyticsInstanceResponse getAnalyticsInstance(GetAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (GetAnalyticsInstanceResponse)this.clientCall(request, GetAnalyticsInstanceResponse::builder).logger(LOG, "getAnalyticsInstance").serviceDetails("Analytics", "GetAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/GetAnalyticsInstance").method(Method.GET).requestBuilder(GetAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AnalyticsInstance.class, GetAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", GetAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnalyticsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPrivateAccessChannelResponse getPrivateAccessChannel(GetPrivateAccessChannelRequest request) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (GetPrivateAccessChannelResponse)this.clientCall(request, GetPrivateAccessChannelResponse::builder).logger(LOG, "getPrivateAccessChannel").serviceDetails("Analytics", "GetPrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/GetPrivateAccessChannel").method(Method.GET).requestBuilder(GetPrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PrivateAccessChannel.class, GetPrivateAccessChannelResponse.Builder::privateAccessChannel).handleResponseHeaderString("etag", GetPrivateAccessChannelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPrivateAccessChannelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Analytics", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListAnalyticsInstancesResponse listAnalyticsInstances(ListAnalyticsInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAnalyticsInstancesResponse)this.clientCall(request, ListAnalyticsInstancesResponse::builder).logger(LOG, "listAnalyticsInstances").serviceDetails("Analytics", "ListAnalyticsInstances", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstanceSummary/ListAnalyticsInstances").method(Method.GET).requestBuilder(ListAnalyticsInstancesRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).appendEnumQueryParam("capacityType", (BmcEnum)request.getCapacityType()).appendEnumQueryParam("featureSet", (BmcEnum)request.getFeatureSet()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(AnalyticsInstanceSummary.class, ListAnalyticsInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAnalyticsInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAnalyticsInstancesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Analytics", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Analytics", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestLog/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequestLog.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Analytics", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190331").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("resourceType", (BmcEnum)request.getResourceType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScaleAnalyticsInstanceResponse scaleAnalyticsInstance(ScaleAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleAnalyticsInstanceDetails(), "scaleAnalyticsInstanceDetails is required");
        return (ScaleAnalyticsInstanceResponse)this.clientCall(request, ScaleAnalyticsInstanceResponse::builder).logger(LOG, "scaleAnalyticsInstance").serviceDetails("Analytics", "ScaleAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/ScaleAnalyticsInstance").method(Method.POST).requestBuilder(ScaleAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("scale").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ScaleAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ScaleAnalyticsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public SetKmsKeyResponse setKmsKey(SetKmsKeyRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSetKmsKeyDetails(), "setKmsKeyDetails is required");
        return (SetKmsKeyResponse)this.clientCall(request, SetKmsKeyResponse::builder).logger(LOG, "setKmsKey").serviceDetails("Analytics", "SetKmsKey", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/SetKmsKey").method(Method.POST).requestBuilder(SetKmsKeyRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("setKmsKey").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", SetKmsKeyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", SetKmsKeyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartAnalyticsInstanceResponse startAnalyticsInstance(StartAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (StartAnalyticsInstanceResponse)this.clientCall(request, StartAnalyticsInstanceResponse::builder).logger(LOG, "startAnalyticsInstance").serviceDetails("Analytics", "StartAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/StartAnalyticsInstance").method(Method.POST).requestBuilder(StartAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartAnalyticsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopAnalyticsInstanceResponse stopAnalyticsInstance(StopAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        return (StopAnalyticsInstanceResponse)this.clientCall(request, StopAnalyticsInstanceResponse::builder).logger(LOG, "stopAnalyticsInstance").serviceDetails("Analytics", "StopAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/StopAnalyticsInstance").method(Method.POST).requestBuilder(StopAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopAnalyticsInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopAnalyticsInstanceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateAnalyticsInstanceResponse updateAnalyticsInstance(UpdateAnalyticsInstanceRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnalyticsInstanceDetails(), "updateAnalyticsInstanceDetails is required");
        return (UpdateAnalyticsInstanceResponse)this.clientCall(request, UpdateAnalyticsInstanceResponse::builder).logger(LOG, "updateAnalyticsInstance").serviceDetails("Analytics", "UpdateAnalyticsInstance", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdateAnalyticsInstance").method(Method.PUT).requestBuilder(UpdateAnalyticsInstanceRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyticsInstance.class, UpdateAnalyticsInstanceResponse.Builder::analyticsInstance).handleResponseHeaderString("etag", UpdateAnalyticsInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAnalyticsInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePrivateAccessChannelResponse updatePrivateAccessChannel(UpdatePrivateAccessChannelRequest request) {
        Validate.notBlank((String)request.getPrivateAccessChannelKey(), (String)"privateAccessChannelKey must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateAccessChannelDetails(), "updatePrivateAccessChannelDetails is required");
        return (UpdatePrivateAccessChannelResponse)this.clientCall(request, UpdatePrivateAccessChannelResponse::builder).logger(LOG, "updatePrivateAccessChannel").serviceDetails("Analytics", "UpdatePrivateAccessChannel", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdatePrivateAccessChannel").method(Method.PUT).requestBuilder(UpdatePrivateAccessChannelRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("privateAccessChannels").appendPathParam(request.getPrivateAccessChannelKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdatePrivateAccessChannelResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePrivateAccessChannelResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateVanityUrlResponse updateVanityUrl(UpdateVanityUrlRequest request) {
        Validate.notBlank((String)request.getAnalyticsInstanceId(), (String)"analyticsInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVanityUrlKey(), (String)"vanityUrlKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVanityUrlDetails(), "updateVanityUrlDetails is required");
        return (UpdateVanityUrlResponse)this.clientCall(request, UpdateVanityUrlResponse::builder).logger(LOG, "updateVanityUrl").serviceDetails("Analytics", "UpdateVanityUrl", "https://docs.oracle.com/iaas/api/#/en/analytics/20190331/AnalyticsInstance/UpdateVanityUrl").method(Method.PUT).requestBuilder(UpdateVanityUrlRequest::builder).basePath("/20190331").appendPathParam("analyticsInstances").appendPathParam(request.getAnalyticsInstanceId()).appendPathParam("vanityUrls").appendPathParam(request.getVanityUrlKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateVanityUrlResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateVanityUrlResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public AnalyticsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AnalyticsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnalyticsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnalyticsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnalyticsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnalyticsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnalyticsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "analytics";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"analytics");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AnalyticsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnalyticsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

