/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.analytics.model.SetKmsKeyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SetKmsKeyRequest
extends BmcRequest<SetKmsKeyDetails> {
    private String analyticsInstanceId;
    private SetKmsKeyDetails setKmsKeyDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public SetKmsKeyDetails getSetKmsKeyDetails() {
        return this.setKmsKeyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public SetKmsKeyDetails getBody$() {
        return this.setKmsKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().analyticsInstanceId(this.analyticsInstanceId).setKmsKeyDetails(this.setKmsKeyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",analyticsInstanceId=").append(String.valueOf(this.analyticsInstanceId));
        sb.append(",setKmsKeyDetails=").append(String.valueOf((Object)this.setKmsKeyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetKmsKeyRequest)) {
            return false;
        }
        SetKmsKeyRequest other = (SetKmsKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.analyticsInstanceId, other.analyticsInstanceId) && Objects.equals((Object)this.setKmsKeyDetails, (Object)other.setKmsKeyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.analyticsInstanceId == null ? 43 : this.analyticsInstanceId.hashCode());
        result = result * 59 + (this.setKmsKeyDetails == null ? 43 : this.setKmsKeyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SetKmsKeyRequest, SetKmsKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String analyticsInstanceId = null;
        private SetKmsKeyDetails setKmsKeyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder setKmsKeyDetails(SetKmsKeyDetails setKmsKeyDetails) {
            this.setKmsKeyDetails = setKmsKeyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SetKmsKeyRequest o) {
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.setKmsKeyDetails(o.getSetKmsKeyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SetKmsKeyRequest build() {
            SetKmsKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SetKmsKeyDetails body) {
            this.setKmsKeyDetails(body);
            return this;
        }

        public SetKmsKeyRequest buildWithoutInvocationCallback() {
            SetKmsKeyRequest request = new SetKmsKeyRequest();
            request.analyticsInstanceId = this.analyticsInstanceId;
            request.setKmsKeyDetails = this.setKmsKeyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

