/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.analytics.model.PrivateSourceDnsZone;
import com.oracle.bmc.analytics.model.PrivateSourceScanHost;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PrivateAccessChannel
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="egressSourceIpAddresses")
    private final List<String> egressSourceIpAddresses;
    @JsonProperty(value="privateSourceDnsZones")
    private final List<PrivateSourceDnsZone> privateSourceDnsZones;
    @JsonProperty(value="privateSourceScanHosts")
    private final List<PrivateSourceScanHost> privateSourceScanHosts;
    @JsonProperty(value="networkSecurityGroupIds")
    private final List<String> networkSecurityGroupIds;

    @Deprecated
    @ConstructorProperties(value={"key", "displayName", "vcnId", "subnetId", "ipAddress", "egressSourceIpAddresses", "privateSourceDnsZones", "privateSourceScanHosts", "networkSecurityGroupIds"})
    public PrivateAccessChannel(String key, String displayName, String vcnId, String subnetId, String ipAddress, List<String> egressSourceIpAddresses, List<PrivateSourceDnsZone> privateSourceDnsZones, List<PrivateSourceScanHost> privateSourceScanHosts, List<String> networkSecurityGroupIds) {
        this.key = key;
        this.displayName = displayName;
        this.vcnId = vcnId;
        this.subnetId = subnetId;
        this.ipAddress = ipAddress;
        this.egressSourceIpAddresses = egressSourceIpAddresses;
        this.privateSourceDnsZones = privateSourceDnsZones;
        this.privateSourceScanHosts = privateSourceScanHosts;
        this.networkSecurityGroupIds = networkSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public List<String> getEgressSourceIpAddresses() {
        return this.egressSourceIpAddresses;
    }

    public List<PrivateSourceDnsZone> getPrivateSourceDnsZones() {
        return this.privateSourceDnsZones;
    }

    public List<PrivateSourceScanHost> getPrivateSourceScanHosts() {
        return this.privateSourceScanHosts;
    }

    public List<String> getNetworkSecurityGroupIds() {
        return this.networkSecurityGroupIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PrivateAccessChannel(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", egressSourceIpAddresses=").append(String.valueOf(this.egressSourceIpAddresses));
        sb.append(", privateSourceDnsZones=").append(String.valueOf(this.privateSourceDnsZones));
        sb.append(", privateSourceScanHosts=").append(String.valueOf(this.privateSourceScanHosts));
        sb.append(", networkSecurityGroupIds=").append(String.valueOf(this.networkSecurityGroupIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrivateAccessChannel)) {
            return false;
        }
        PrivateAccessChannel other = (PrivateAccessChannel)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.egressSourceIpAddresses, other.egressSourceIpAddresses) && Objects.equals(this.privateSourceDnsZones, other.privateSourceDnsZones) && Objects.equals(this.privateSourceScanHosts, other.privateSourceScanHosts) && Objects.equals(this.networkSecurityGroupIds, other.networkSecurityGroupIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.egressSourceIpAddresses == null ? 43 : this.egressSourceIpAddresses.hashCode());
        result = result * 59 + (this.privateSourceDnsZones == null ? 43 : this.privateSourceDnsZones.hashCode());
        result = result * 59 + (this.privateSourceScanHosts == null ? 43 : this.privateSourceScanHosts.hashCode());
        result = result * 59 + (this.networkSecurityGroupIds == null ? 43 : this.networkSecurityGroupIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="egressSourceIpAddresses")
        private List<String> egressSourceIpAddresses;
        @JsonProperty(value="privateSourceDnsZones")
        private List<PrivateSourceDnsZone> privateSourceDnsZones;
        @JsonProperty(value="privateSourceScanHosts")
        private List<PrivateSourceScanHost> privateSourceScanHosts;
        @JsonProperty(value="networkSecurityGroupIds")
        private List<String> networkSecurityGroupIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder egressSourceIpAddresses(List<String> egressSourceIpAddresses) {
            this.egressSourceIpAddresses = egressSourceIpAddresses;
            this.__explicitlySet__.add("egressSourceIpAddresses");
            return this;
        }

        public Builder privateSourceDnsZones(List<PrivateSourceDnsZone> privateSourceDnsZones) {
            this.privateSourceDnsZones = privateSourceDnsZones;
            this.__explicitlySet__.add("privateSourceDnsZones");
            return this;
        }

        public Builder privateSourceScanHosts(List<PrivateSourceScanHost> privateSourceScanHosts) {
            this.privateSourceScanHosts = privateSourceScanHosts;
            this.__explicitlySet__.add("privateSourceScanHosts");
            return this;
        }

        public Builder networkSecurityGroupIds(List<String> networkSecurityGroupIds) {
            this.networkSecurityGroupIds = networkSecurityGroupIds;
            this.__explicitlySet__.add("networkSecurityGroupIds");
            return this;
        }

        public PrivateAccessChannel build() {
            PrivateAccessChannel model = new PrivateAccessChannel(this.key, this.displayName, this.vcnId, this.subnetId, this.ipAddress, this.egressSourceIpAddresses, this.privateSourceDnsZones, this.privateSourceScanHosts, this.networkSecurityGroupIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PrivateAccessChannel model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("egressSourceIpAddresses")) {
                this.egressSourceIpAddresses(model.getEgressSourceIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("privateSourceDnsZones")) {
                this.privateSourceDnsZones(model.getPrivateSourceDnsZones());
            }
            if (model.wasPropertyExplicitlySet("privateSourceScanHosts")) {
                this.privateSourceScanHosts(model.getPrivateSourceScanHosts());
            }
            if (model.wasPropertyExplicitlySet("networkSecurityGroupIds")) {
                this.networkSecurityGroupIds(model.getNetworkSecurityGroupIds());
            }
            return this;
        }
    }
}

