/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.analytics.model.CreateAnalyticsInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateAnalyticsInstanceRequest
extends BmcRequest<CreateAnalyticsInstanceDetails> {
    private CreateAnalyticsInstanceDetails createAnalyticsInstanceDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateAnalyticsInstanceDetails getCreateAnalyticsInstanceDetails() {
        return this.createAnalyticsInstanceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateAnalyticsInstanceDetails getBody$() {
        return this.createAnalyticsInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().createAnalyticsInstanceDetails(this.createAnalyticsInstanceDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createAnalyticsInstanceDetails=").append(String.valueOf((Object)this.createAnalyticsInstanceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAnalyticsInstanceRequest)) {
            return false;
        }
        CreateAnalyticsInstanceRequest other = (CreateAnalyticsInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createAnalyticsInstanceDetails, (Object)other.createAnalyticsInstanceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createAnalyticsInstanceDetails == null ? 43 : this.createAnalyticsInstanceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAnalyticsInstanceRequest, CreateAnalyticsInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateAnalyticsInstanceDetails createAnalyticsInstanceDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createAnalyticsInstanceDetails(CreateAnalyticsInstanceDetails createAnalyticsInstanceDetails) {
            this.createAnalyticsInstanceDetails = createAnalyticsInstanceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAnalyticsInstanceRequest o) {
            this.createAnalyticsInstanceDetails(o.getCreateAnalyticsInstanceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAnalyticsInstanceRequest build() {
            CreateAnalyticsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateAnalyticsInstanceDetails body) {
            this.createAnalyticsInstanceDetails(body);
            return this;
        }

        public CreateAnalyticsInstanceRequest buildWithoutInvocationCallback() {
            CreateAnalyticsInstanceRequest request = new CreateAnalyticsInstanceRequest();
            request.createAnalyticsInstanceDetails = this.createAnalyticsInstanceDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

