/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.analytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.analytics.model.UpdateAnalyticsInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAnalyticsInstanceRequest
extends BmcRequest<UpdateAnalyticsInstanceDetails> {
    private String analyticsInstanceId;
    private UpdateAnalyticsInstanceDetails updateAnalyticsInstanceDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getAnalyticsInstanceId() {
        return this.analyticsInstanceId;
    }

    public UpdateAnalyticsInstanceDetails getUpdateAnalyticsInstanceDetails() {
        return this.updateAnalyticsInstanceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAnalyticsInstanceDetails getBody$() {
        return this.updateAnalyticsInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().analyticsInstanceId(this.analyticsInstanceId).updateAnalyticsInstanceDetails(this.updateAnalyticsInstanceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",analyticsInstanceId=").append(String.valueOf(this.analyticsInstanceId));
        sb.append(",updateAnalyticsInstanceDetails=").append(String.valueOf((Object)this.updateAnalyticsInstanceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAnalyticsInstanceRequest)) {
            return false;
        }
        UpdateAnalyticsInstanceRequest other = (UpdateAnalyticsInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.analyticsInstanceId, other.analyticsInstanceId) && Objects.equals((Object)this.updateAnalyticsInstanceDetails, (Object)other.updateAnalyticsInstanceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.analyticsInstanceId == null ? 43 : this.analyticsInstanceId.hashCode());
        result = result * 59 + (this.updateAnalyticsInstanceDetails == null ? 43 : this.updateAnalyticsInstanceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAnalyticsInstanceRequest, UpdateAnalyticsInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String analyticsInstanceId = null;
        private UpdateAnalyticsInstanceDetails updateAnalyticsInstanceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder analyticsInstanceId(String analyticsInstanceId) {
            this.analyticsInstanceId = analyticsInstanceId;
            return this;
        }

        public Builder updateAnalyticsInstanceDetails(UpdateAnalyticsInstanceDetails updateAnalyticsInstanceDetails) {
            this.updateAnalyticsInstanceDetails = updateAnalyticsInstanceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAnalyticsInstanceRequest o) {
            this.analyticsInstanceId(o.getAnalyticsInstanceId());
            this.updateAnalyticsInstanceDetails(o.getUpdateAnalyticsInstanceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAnalyticsInstanceRequest build() {
            UpdateAnalyticsInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAnalyticsInstanceDetails body) {
            this.updateAnalyticsInstanceDetails(body);
            return this;
        }

        public UpdateAnalyticsInstanceRequest buildWithoutInvocationCallback() {
            UpdateAnalyticsInstanceRequest request = new UpdateAnalyticsInstanceRequest();
            request.analyticsInstanceId = this.analyticsInstanceId;
            request.updateAnalyticsInstanceDetails = this.updateAnalyticsInstanceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

