/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.announcementsservice.AnnouncementPaginators;
import com.oracle.bmc.announcementsservice.model.Announcement;
import com.oracle.bmc.announcementsservice.model.AnnouncementUserStatusDetails;
import com.oracle.bmc.announcementsservice.model.AnnouncementsCollection;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementRequest;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateAnnouncementUserStatusRequest;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementResponse;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementUserStatusResponse;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateAnnouncementUserStatusResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementClient
extends BaseSyncClient
implements com.oracle.bmc.announcementsservice.Announcement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANNOUNCEMENT").serviceEndpointPrefix("announcements").serviceEndpointTemplate("https://announcements.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnnouncementClient.class);
    private final AnnouncementPaginators paginators = new AnnouncementPaginators(this);

    AnnouncementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetAnnouncementResponse getAnnouncement(GetAnnouncementRequest request) {
        Validate.notBlank((String)request.getAnnouncementId(), (String)"announcementId must not be blank", (Object[])new Object[0]);
        return (GetAnnouncementResponse)this.clientCall(request, GetAnnouncementResponse::builder).logger(LOG, "getAnnouncement").serviceDetails("Announcement", "GetAnnouncement", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/Announcement/GetAnnouncement").method(Method.GET).requestBuilder(GetAnnouncementRequest::builder).basePath("/20180904").appendPathParam("announcements").appendPathParam(request.getAnnouncementId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Announcement.class, GetAnnouncementResponse.Builder::announcement).handleResponseHeaderString("opc-request-id", GetAnnouncementResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAnnouncementResponse.Builder::etag).callSync();
    }

    @Override
    public GetAnnouncementUserStatusResponse getAnnouncementUserStatus(GetAnnouncementUserStatusRequest request) {
        Validate.notBlank((String)request.getAnnouncementId(), (String)"announcementId must not be blank", (Object[])new Object[0]);
        return (GetAnnouncementUserStatusResponse)this.clientCall(request, GetAnnouncementUserStatusResponse::builder).logger(LOG, "getAnnouncementUserStatus").serviceDetails("Announcement", "GetAnnouncementUserStatus", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementUserStatusDetails/GetAnnouncementUserStatus").method(Method.GET).requestBuilder(GetAnnouncementUserStatusRequest::builder).basePath("/20180904").appendPathParam("announcements").appendPathParam(request.getAnnouncementId()).appendPathParam("userStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementUserStatusDetails.class, GetAnnouncementUserStatusResponse.Builder::announcementUserStatusDetails).handleResponseHeaderString("opc-request-id", GetAnnouncementUserStatusResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAnnouncementUserStatusResponse.Builder::etag).callSync();
    }

    @Override
    public ListAnnouncementsResponse listAnnouncements(ListAnnouncementsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAnnouncementsResponse)this.clientCall(request, ListAnnouncementsResponse::builder).logger(LOG, "listAnnouncements").serviceDetails("Announcement", "ListAnnouncements", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementsCollection/ListAnnouncements").method(Method.GET).requestBuilder(ListAnnouncementsRequest::builder).basePath("/20180904").appendPathParam("announcements").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("announcementType", (Object)request.getAnnouncementType()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("isBanner", (Object)request.getIsBanner()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("timeOneEarliestTime", (Object)request.getTimeOneEarliestTime()).appendQueryParam("timeOneLatestTime", (Object)request.getTimeOneLatestTime()).appendQueryParam("environmentName", (Object)request.getEnvironmentName()).appendQueryParam("service", (Object)request.getService()).appendEnumQueryParam("platformType", (BmcEnum)request.getPlatformType()).appendListQueryParam("excludeAnnouncementTypes", request.getExcludeAnnouncementTypes(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementsCollection.class, ListAnnouncementsResponse.Builder::announcementsCollection).handleResponseHeaderString("opc-next-page", ListAnnouncementsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListAnnouncementsResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", ListAnnouncementsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateAnnouncementUserStatusResponse updateAnnouncementUserStatus(UpdateAnnouncementUserStatusRequest request) {
        Validate.notBlank((String)request.getAnnouncementId(), (String)"announcementId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStatusDetails(), "statusDetails is required");
        return (UpdateAnnouncementUserStatusResponse)this.clientCall(request, UpdateAnnouncementUserStatusResponse::builder).logger(LOG, "updateAnnouncementUserStatus").serviceDetails("Announcement", "UpdateAnnouncementUserStatus", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementUserStatusDetails/UpdateAnnouncementUserStatus").method(Method.PUT).requestBuilder(UpdateAnnouncementUserStatusRequest::builder).basePath("/20180904").appendPathParam("announcements").appendPathParam(request.getAnnouncementId()).appendPathParam("userStatus").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnnouncementUserStatusDetails.class, UpdateAnnouncementUserStatusResponse.Builder::announcementUserStatusDetails).handleResponseHeaderString("opc-request-id", UpdateAnnouncementUserStatusResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAnnouncementUserStatusResponse.Builder::etag).callSync();
    }

    @Override
    public AnnouncementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AnnouncementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnnouncementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnnouncementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnnouncementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnnouncementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnnouncementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnnouncementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnnouncementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnnouncementClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AnnouncementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnnouncementClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

