/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.announcementsservice.AnnouncementsPreferencesAsync;
import com.oracle.bmc.announcementsservice.model.AnnouncementsPreferences;
import com.oracle.bmc.announcementsservice.model.AnnouncementsPreferencesSummary;
import com.oracle.bmc.announcementsservice.requests.CreateAnnouncementsPreferenceRequest;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementsPreferenceRequest;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementsPreferencesRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateAnnouncementsPreferenceRequest;
import com.oracle.bmc.announcementsservice.responses.CreateAnnouncementsPreferenceResponse;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementsPreferenceResponse;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementsPreferencesResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateAnnouncementsPreferenceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementsPreferencesAsyncClient
extends BaseAsyncClient
implements AnnouncementsPreferencesAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANNOUNCEMENTSPREFERENCES").serviceEndpointPrefix("announcements").serviceEndpointTemplate("https://announcements.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnnouncementsPreferencesAsyncClient.class);

    AnnouncementsPreferencesAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateAnnouncementsPreferenceResponse> createAnnouncementsPreference(CreateAnnouncementsPreferenceRequest request, AsyncHandler<CreateAnnouncementsPreferenceRequest, CreateAnnouncementsPreferenceResponse> handler) {
        Objects.requireNonNull(request.getAnnouncementsPreferenceDetails(), "announcementsPreferenceDetails is required");
        return this.clientCall(request, CreateAnnouncementsPreferenceResponse::builder).logger(LOG, "createAnnouncementsPreference").serviceDetails("AnnouncementsPreferences", "CreateAnnouncementsPreference", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementsPreferencesSummary/CreateAnnouncementsPreference").method(Method.POST).requestBuilder(CreateAnnouncementsPreferenceRequest::builder).basePath("/20180904").appendPathParam("announcementsPreferences").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AnnouncementsPreferencesSummary.class, CreateAnnouncementsPreferenceResponse.Builder::announcementsPreferencesSummary).handleResponseHeaderString("opc-request-id", CreateAnnouncementsPreferenceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAnnouncementsPreferenceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetAnnouncementsPreferenceResponse> getAnnouncementsPreference(GetAnnouncementsPreferenceRequest request, AsyncHandler<GetAnnouncementsPreferenceRequest, GetAnnouncementsPreferenceResponse> handler) {
        Validate.notBlank((String)request.getPreferenceId(), (String)"preferenceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAnnouncementsPreferenceResponse::builder).logger(LOG, "getAnnouncementsPreference").serviceDetails("AnnouncementsPreferences", "GetAnnouncementsPreference", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementsPreferences/GetAnnouncementsPreference").method(Method.GET).requestBuilder(GetAnnouncementsPreferenceRequest::builder).basePath("/20180904").appendPathParam("announcementsPreferences").appendPathParam(request.getPreferenceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementsPreferences.class, GetAnnouncementsPreferenceResponse.Builder::announcementsPreferences).handleResponseHeaderString("opc-request-id", GetAnnouncementsPreferenceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAnnouncementsPreferenceResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListAnnouncementsPreferencesResponse> listAnnouncementsPreferences(ListAnnouncementsPreferencesRequest request, AsyncHandler<ListAnnouncementsPreferencesRequest, ListAnnouncementsPreferencesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAnnouncementsPreferencesResponse::builder).logger(LOG, "listAnnouncementsPreferences").serviceDetails("AnnouncementsPreferences", "ListAnnouncementsPreferences", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementsPreferencesSummary/ListAnnouncementsPreferences").method(Method.GET).requestBuilder(ListAnnouncementsPreferencesRequest::builder).basePath("/20180904").appendPathParam("announcementsPreferences").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AnnouncementsPreferencesSummary.class, ListAnnouncementsPreferencesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAnnouncementsPreferencesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAnnouncementsPreferencesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAnnouncementsPreferenceResponse> updateAnnouncementsPreference(UpdateAnnouncementsPreferenceRequest request, AsyncHandler<UpdateAnnouncementsPreferenceRequest, UpdateAnnouncementsPreferenceResponse> handler) {
        Validate.notBlank((String)request.getPreferenceId(), (String)"preferenceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAnnouncementsPreferenceDetails(), "announcementsPreferenceDetails is required");
        return this.clientCall(request, UpdateAnnouncementsPreferenceResponse::builder).logger(LOG, "updateAnnouncementsPreference").serviceDetails("AnnouncementsPreferences", "UpdateAnnouncementsPreference", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementsPreferencesSummary/UpdateAnnouncementsPreference").method(Method.PUT).requestBuilder(UpdateAnnouncementsPreferenceRequest::builder).basePath("/20180904").appendPathParam("announcementsPreferences").appendPathParam(request.getPreferenceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(AnnouncementsPreferencesSummary.class, UpdateAnnouncementsPreferenceResponse.Builder::announcementsPreferencesSummary).handleResponseHeaderString("opc-request-id", UpdateAnnouncementsPreferenceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAnnouncementsPreferenceResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnnouncementsPreferencesAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnnouncementsPreferencesAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnnouncementsPreferencesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnnouncementsPreferencesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnnouncementsPreferencesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnnouncementsPreferencesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AnnouncementsPreferencesAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnnouncementsPreferencesAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnnouncementsPreferencesAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AnnouncementsPreferencesAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnnouncementsPreferencesAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

