/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListAnnouncementsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String announcementType;
    private LifecycleState lifecycleState;
    private Boolean isBanner;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Date timeOneEarliestTime;
    private Date timeOneLatestTime;
    private String environmentName;
    private String service;
    private PlatformType platformType;
    private List<String> excludeAnnouncementTypes;
    private Boolean shouldShowOnlyLatestInChain;
    private String chainId;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getAnnouncementType() {
        return this.announcementType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsBanner() {
        return this.isBanner;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Date getTimeOneEarliestTime() {
        return this.timeOneEarliestTime;
    }

    public Date getTimeOneLatestTime() {
        return this.timeOneLatestTime;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getService() {
        return this.service;
    }

    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public List<String> getExcludeAnnouncementTypes() {
        return this.excludeAnnouncementTypes;
    }

    public Boolean getShouldShowOnlyLatestInChain() {
        return this.shouldShowOnlyLatestInChain;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).announcementType(this.announcementType).lifecycleState(this.lifecycleState).isBanner(this.isBanner).sortBy(this.sortBy).sortOrder(this.sortOrder).timeOneEarliestTime(this.timeOneEarliestTime).timeOneLatestTime(this.timeOneLatestTime).environmentName(this.environmentName).service(this.service).platformType(this.platformType).excludeAnnouncementTypes(this.excludeAnnouncementTypes).shouldShowOnlyLatestInChain(this.shouldShowOnlyLatestInChain).chainId(this.chainId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",announcementType=").append(String.valueOf(this.announcementType));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",isBanner=").append(String.valueOf(this.isBanner));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",timeOneEarliestTime=").append(String.valueOf(this.timeOneEarliestTime));
        sb.append(",timeOneLatestTime=").append(String.valueOf(this.timeOneLatestTime));
        sb.append(",environmentName=").append(String.valueOf(this.environmentName));
        sb.append(",service=").append(String.valueOf(this.service));
        sb.append(",platformType=").append(String.valueOf((Object)this.platformType));
        sb.append(",excludeAnnouncementTypes=").append(String.valueOf(this.excludeAnnouncementTypes));
        sb.append(",shouldShowOnlyLatestInChain=").append(String.valueOf(this.shouldShowOnlyLatestInChain));
        sb.append(",chainId=").append(String.valueOf(this.chainId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAnnouncementsRequest)) {
            return false;
        }
        ListAnnouncementsRequest other = (ListAnnouncementsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.announcementType, other.announcementType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isBanner, other.isBanner) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.timeOneEarliestTime, other.timeOneEarliestTime) && Objects.equals(this.timeOneLatestTime, other.timeOneLatestTime) && Objects.equals(this.environmentName, other.environmentName) && Objects.equals(this.service, other.service) && Objects.equals((Object)this.platformType, (Object)other.platformType) && Objects.equals(this.excludeAnnouncementTypes, other.excludeAnnouncementTypes) && Objects.equals(this.shouldShowOnlyLatestInChain, other.shouldShowOnlyLatestInChain) && Objects.equals(this.chainId, other.chainId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.announcementType == null ? 43 : this.announcementType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isBanner == null ? 43 : this.isBanner.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.timeOneEarliestTime == null ? 43 : this.timeOneEarliestTime.hashCode());
        result = result * 59 + (this.timeOneLatestTime == null ? 43 : this.timeOneLatestTime.hashCode());
        result = result * 59 + (this.environmentName == null ? 43 : this.environmentName.hashCode());
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.platformType == null ? 43 : this.platformType.hashCode());
        result = result * 59 + (this.excludeAnnouncementTypes == null ? 43 : this.excludeAnnouncementTypes.hashCode());
        result = result * 59 + (this.shouldShowOnlyLatestInChain == null ? 43 : this.shouldShowOnlyLatestInChain.hashCode());
        result = result * 59 + (this.chainId == null ? 43 : this.chainId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAnnouncementsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private String announcementType = null;
        private LifecycleState lifecycleState = null;
        private Boolean isBanner = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Date timeOneEarliestTime = null;
        private Date timeOneLatestTime = null;
        private String environmentName = null;
        private String service = null;
        private PlatformType platformType = null;
        private List<String> excludeAnnouncementTypes = null;
        private Boolean shouldShowOnlyLatestInChain = null;
        private String chainId = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder announcementType(String announcementType) {
            this.announcementType = announcementType;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder isBanner(Boolean isBanner) {
            this.isBanner = isBanner;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder timeOneEarliestTime(Date timeOneEarliestTime) {
            this.timeOneEarliestTime = timeOneEarliestTime;
            return this;
        }

        public Builder timeOneLatestTime(Date timeOneLatestTime) {
            this.timeOneLatestTime = timeOneLatestTime;
            return this;
        }

        public Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder platformType(PlatformType platformType) {
            this.platformType = platformType;
            return this;
        }

        public Builder excludeAnnouncementTypes(List<String> excludeAnnouncementTypes) {
            this.excludeAnnouncementTypes = excludeAnnouncementTypes;
            return this;
        }

        public Builder excludeAnnouncementTypes(String singularValue) {
            return this.excludeAnnouncementTypes(Arrays.asList(singularValue));
        }

        public Builder shouldShowOnlyLatestInChain(Boolean shouldShowOnlyLatestInChain) {
            this.shouldShowOnlyLatestInChain = shouldShowOnlyLatestInChain;
            return this;
        }

        public Builder chainId(String chainId) {
            this.chainId = chainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAnnouncementsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.announcementType(o.getAnnouncementType());
            this.lifecycleState(o.getLifecycleState());
            this.isBanner(o.getIsBanner());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.timeOneEarliestTime(o.getTimeOneEarliestTime());
            this.timeOneLatestTime(o.getTimeOneLatestTime());
            this.environmentName(o.getEnvironmentName());
            this.service(o.getService());
            this.platformType(o.getPlatformType());
            this.excludeAnnouncementTypes(o.getExcludeAnnouncementTypes());
            this.shouldShowOnlyLatestInChain(o.getShouldShowOnlyLatestInChain());
            this.chainId(o.getChainId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAnnouncementsRequest build() {
            ListAnnouncementsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAnnouncementsRequest buildWithoutInvocationCallback() {
            ListAnnouncementsRequest request = new ListAnnouncementsRequest();
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.announcementType = this.announcementType;
            request.lifecycleState = this.lifecycleState;
            request.isBanner = this.isBanner;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.timeOneEarliestTime = this.timeOneEarliestTime;
            request.timeOneLatestTime = this.timeOneLatestTime;
            request.environmentName = this.environmentName;
            request.service = this.service;
            request.platformType = this.platformType;
            request.excludeAnnouncementTypes = this.excludeAnnouncementTypes;
            request.shouldShowOnlyLatestInChain = this.shouldShowOnlyLatestInChain;
            request.chainId = this.chainId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum PlatformType implements BmcEnum
    {
        Iaas("IAAS"),
        Saas("SAAS");

        private final String value;
        private static Map<String, PlatformType> map;

        private PlatformType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlatformType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PlatformType: " + key);
        }

        static {
            map = new HashMap<String, PlatformType>();
            for (PlatformType v : PlatformType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeOneValue("timeOneValue"),
        TimeTwoValue("timeTwoValue"),
        TimeCreated("timeCreated"),
        ReferenceTicketNumber("referenceTicketNumber"),
        Summary("summary"),
        AnnouncementType("announcementType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

