/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.announcementsservice.model.UpdateFilterGroupDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateFilterGroupRequest
extends BmcRequest<UpdateFilterGroupDetails> {
    private String announcementSubscriptionId;
    private String filterGroupName;
    private UpdateFilterGroupDetails updateFilterGroupDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getAnnouncementSubscriptionId() {
        return this.announcementSubscriptionId;
    }

    public String getFilterGroupName() {
        return this.filterGroupName;
    }

    public UpdateFilterGroupDetails getUpdateFilterGroupDetails() {
        return this.updateFilterGroupDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateFilterGroupDetails getBody$() {
        return this.updateFilterGroupDetails;
    }

    public Builder toBuilder() {
        return new Builder().announcementSubscriptionId(this.announcementSubscriptionId).filterGroupName(this.filterGroupName).updateFilterGroupDetails(this.updateFilterGroupDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",announcementSubscriptionId=").append(String.valueOf(this.announcementSubscriptionId));
        sb.append(",filterGroupName=").append(String.valueOf(this.filterGroupName));
        sb.append(",updateFilterGroupDetails=").append(String.valueOf((Object)this.updateFilterGroupDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateFilterGroupRequest)) {
            return false;
        }
        UpdateFilterGroupRequest other = (UpdateFilterGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.announcementSubscriptionId, other.announcementSubscriptionId) && Objects.equals(this.filterGroupName, other.filterGroupName) && Objects.equals((Object)this.updateFilterGroupDetails, (Object)other.updateFilterGroupDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.announcementSubscriptionId == null ? 43 : this.announcementSubscriptionId.hashCode());
        result = result * 59 + (this.filterGroupName == null ? 43 : this.filterGroupName.hashCode());
        result = result * 59 + (this.updateFilterGroupDetails == null ? 43 : this.updateFilterGroupDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateFilterGroupRequest, UpdateFilterGroupDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String announcementSubscriptionId = null;
        private String filterGroupName = null;
        private UpdateFilterGroupDetails updateFilterGroupDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder announcementSubscriptionId(String announcementSubscriptionId) {
            this.announcementSubscriptionId = announcementSubscriptionId;
            return this;
        }

        public Builder filterGroupName(String filterGroupName) {
            this.filterGroupName = filterGroupName;
            return this;
        }

        public Builder updateFilterGroupDetails(UpdateFilterGroupDetails updateFilterGroupDetails) {
            this.updateFilterGroupDetails = updateFilterGroupDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFilterGroupRequest o) {
            this.announcementSubscriptionId(o.getAnnouncementSubscriptionId());
            this.filterGroupName(o.getFilterGroupName());
            this.updateFilterGroupDetails(o.getUpdateFilterGroupDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFilterGroupRequest build() {
            UpdateFilterGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateFilterGroupDetails body) {
            this.updateFilterGroupDetails(body);
            return this;
        }

        public UpdateFilterGroupRequest buildWithoutInvocationCallback() {
            UpdateFilterGroupRequest request = new UpdateFilterGroupRequest();
            request.announcementSubscriptionId = this.announcementSubscriptionId;
            request.filterGroupName = this.filterGroupName;
            request.updateFilterGroupDetails = this.updateFilterGroupDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

