/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.announcementsservice.AnnouncementSubscriptionPaginators;
import com.oracle.bmc.announcementsservice.AnnouncementSubscriptionWaiters;
import com.oracle.bmc.announcementsservice.model.AnnouncementSubscription;
import com.oracle.bmc.announcementsservice.model.AnnouncementSubscriptionCollection;
import com.oracle.bmc.announcementsservice.model.FilterGroup;
import com.oracle.bmc.announcementsservice.requests.ChangeAnnouncementSubscriptionCompartmentRequest;
import com.oracle.bmc.announcementsservice.requests.CreateAnnouncementSubscriptionRequest;
import com.oracle.bmc.announcementsservice.requests.CreateFilterGroupRequest;
import com.oracle.bmc.announcementsservice.requests.DeleteAnnouncementSubscriptionRequest;
import com.oracle.bmc.announcementsservice.requests.DeleteFilterGroupRequest;
import com.oracle.bmc.announcementsservice.requests.GetAnnouncementSubscriptionRequest;
import com.oracle.bmc.announcementsservice.requests.ListAnnouncementSubscriptionsRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateAnnouncementSubscriptionRequest;
import com.oracle.bmc.announcementsservice.requests.UpdateFilterGroupRequest;
import com.oracle.bmc.announcementsservice.responses.ChangeAnnouncementSubscriptionCompartmentResponse;
import com.oracle.bmc.announcementsservice.responses.CreateAnnouncementSubscriptionResponse;
import com.oracle.bmc.announcementsservice.responses.CreateFilterGroupResponse;
import com.oracle.bmc.announcementsservice.responses.DeleteAnnouncementSubscriptionResponse;
import com.oracle.bmc.announcementsservice.responses.DeleteFilterGroupResponse;
import com.oracle.bmc.announcementsservice.responses.GetAnnouncementSubscriptionResponse;
import com.oracle.bmc.announcementsservice.responses.ListAnnouncementSubscriptionsResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateAnnouncementSubscriptionResponse;
import com.oracle.bmc.announcementsservice.responses.UpdateFilterGroupResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementSubscriptionClient
extends BaseSyncClient
implements com.oracle.bmc.announcementsservice.AnnouncementSubscription {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ANNOUNCEMENTSUBSCRIPTION").serviceEndpointPrefix("announcements").serviceEndpointTemplate("https://announcements.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AnnouncementSubscriptionClient.class);
    private final AnnouncementSubscriptionWaiters waiters;
    private final AnnouncementSubscriptionPaginators paginators;

    AnnouncementSubscriptionClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AnnouncementSubscription-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AnnouncementSubscriptionWaiters(executorService, this);
        this.paginators = new AnnouncementSubscriptionPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeAnnouncementSubscriptionCompartmentResponse changeAnnouncementSubscriptionCompartment(ChangeAnnouncementSubscriptionCompartmentRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAnnouncementSubscriptionCompartmentDetails(), "changeAnnouncementSubscriptionCompartmentDetails is required");
        return (ChangeAnnouncementSubscriptionCompartmentResponse)this.clientCall(request, ChangeAnnouncementSubscriptionCompartmentResponse::builder).logger(LOG, "changeAnnouncementSubscriptionCompartment").serviceDetails("AnnouncementSubscription", "ChangeAnnouncementSubscriptionCompartment", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/ChangeAnnouncementSubscriptionCompartment").method(Method.POST).requestBuilder(ChangeAnnouncementSubscriptionCompartmentRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAnnouncementSubscriptionCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ChangeAnnouncementSubscriptionCompartmentResponse.Builder::etag).callSync();
    }

    @Override
    public CreateAnnouncementSubscriptionResponse createAnnouncementSubscription(CreateAnnouncementSubscriptionRequest request) {
        Objects.requireNonNull(request.getCreateAnnouncementSubscriptionDetails(), "createAnnouncementSubscriptionDetails is required");
        return (CreateAnnouncementSubscriptionResponse)this.clientCall(request, CreateAnnouncementSubscriptionResponse::builder).logger(LOG, "createAnnouncementSubscription").serviceDetails("AnnouncementSubscription", "CreateAnnouncementSubscription", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/CreateAnnouncementSubscription").method(Method.POST).requestBuilder(CreateAnnouncementSubscriptionRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnnouncementSubscription.class, CreateAnnouncementSubscriptionResponse.Builder::announcementSubscription).handleResponseHeaderString("opc-request-id", CreateAnnouncementSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAnnouncementSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public CreateFilterGroupResponse createFilterGroup(CreateFilterGroupRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateFilterGroupDetails(), "createFilterGroupDetails is required");
        return (CreateFilterGroupResponse)this.clientCall(request, CreateFilterGroupResponse::builder).logger(LOG, "createFilterGroup").serviceDetails("AnnouncementSubscription", "CreateFilterGroup", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/CreateFilterGroup").method(Method.POST).requestBuilder(CreateFilterGroupRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).appendPathParam("filterGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(FilterGroup.class, CreateFilterGroupResponse.Builder::filterGroup).handleResponseHeaderString("opc-request-id", CreateFilterGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateFilterGroupResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteAnnouncementSubscriptionResponse deleteAnnouncementSubscription(DeleteAnnouncementSubscriptionRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        return (DeleteAnnouncementSubscriptionResponse)this.clientCall(request, DeleteAnnouncementSubscriptionResponse::builder).logger(LOG, "deleteAnnouncementSubscription").serviceDetails("AnnouncementSubscription", "DeleteAnnouncementSubscription", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/DeleteAnnouncementSubscription").method(Method.DELETE).requestBuilder(DeleteAnnouncementSubscriptionRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAnnouncementSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFilterGroupResponse deleteFilterGroup(DeleteFilterGroupRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilterGroupName(), (String)"filterGroupName must not be blank", (Object[])new Object[0]);
        return (DeleteFilterGroupResponse)this.clientCall(request, DeleteFilterGroupResponse::builder).logger(LOG, "deleteFilterGroup").serviceDetails("AnnouncementSubscription", "DeleteFilterGroup", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/DeleteFilterGroup").method(Method.DELETE).requestBuilder(DeleteFilterGroupRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).appendPathParam("filterGroups").appendPathParam(request.getFilterGroupName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteFilterGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DeleteFilterGroupResponse.Builder::etag).callSync();
    }

    @Override
    public GetAnnouncementSubscriptionResponse getAnnouncementSubscription(GetAnnouncementSubscriptionRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        return (GetAnnouncementSubscriptionResponse)this.clientCall(request, GetAnnouncementSubscriptionResponse::builder).logger(LOG, "getAnnouncementSubscription").serviceDetails("AnnouncementSubscription", "GetAnnouncementSubscription", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/GetAnnouncementSubscription").method(Method.GET).requestBuilder(GetAnnouncementSubscriptionRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementSubscription.class, GetAnnouncementSubscriptionResponse.Builder::announcementSubscription).handleResponseHeaderString("etag", GetAnnouncementSubscriptionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnnouncementSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAnnouncementSubscriptionsResponse listAnnouncementSubscriptions(ListAnnouncementSubscriptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAnnouncementSubscriptionsResponse)this.clientCall(request, ListAnnouncementSubscriptionsResponse::builder).logger(LOG, "listAnnouncementSubscriptions").serviceDetails("AnnouncementSubscription", "ListAnnouncementSubscriptions", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscriptionCollection/ListAnnouncementSubscriptions").method(Method.GET).requestBuilder(ListAnnouncementSubscriptionsRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnouncementSubscriptionCollection.class, ListAnnouncementSubscriptionsResponse.Builder::announcementSubscriptionCollection).handleResponseHeaderString("opc-request-id", ListAnnouncementSubscriptionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnouncementSubscriptionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateAnnouncementSubscriptionResponse updateAnnouncementSubscription(UpdateAnnouncementSubscriptionRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnnouncementSubscriptionDetails(), "updateAnnouncementSubscriptionDetails is required");
        return (UpdateAnnouncementSubscriptionResponse)this.clientCall(request, UpdateAnnouncementSubscriptionResponse::builder).logger(LOG, "updateAnnouncementSubscription").serviceDetails("AnnouncementSubscription", "UpdateAnnouncementSubscription", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/UpdateAnnouncementSubscription").method(Method.PUT).requestBuilder(UpdateAnnouncementSubscriptionRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnnouncementSubscription.class, UpdateAnnouncementSubscriptionResponse.Builder::announcementSubscription).handleResponseHeaderString("opc-request-id", UpdateAnnouncementSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAnnouncementSubscriptionResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateFilterGroupResponse updateFilterGroup(UpdateFilterGroupRequest request) {
        Validate.notBlank((String)request.getAnnouncementSubscriptionId(), (String)"announcementSubscriptionId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilterGroupName(), (String)"filterGroupName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFilterGroupDetails(), "updateFilterGroupDetails is required");
        return (UpdateFilterGroupResponse)this.clientCall(request, UpdateFilterGroupResponse::builder).logger(LOG, "updateFilterGroup").serviceDetails("AnnouncementSubscription", "UpdateFilterGroup", "https://docs.oracle.com/iaas/api/#/en/announcements/0.0.1/AnnouncementSubscription/UpdateFilterGroup").method(Method.PUT).requestBuilder(UpdateFilterGroupRequest::builder).basePath("/20180904").appendPathParam("announcementSubscriptions").appendPathParam(request.getAnnouncementSubscriptionId()).appendPathParam("filterGroups").appendPathParam(request.getFilterGroupName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(FilterGroup.class, UpdateFilterGroupResponse.Builder::filterGroup).handleResponseHeaderString("opc-request-id", UpdateFilterGroupResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateFilterGroupResponse.Builder::etag).callSync();
    }

    @Override
    public AnnouncementSubscriptionWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AnnouncementSubscriptionPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AnnouncementSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AnnouncementSubscriptionClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AnnouncementSubscriptionClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AnnouncementSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AnnouncementSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AnnouncementSubscriptionClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "announcementsservice";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"announcementsservice");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AnnouncementSubscriptionClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AnnouncementSubscriptionClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

