/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.announcementsservice;

import com.oracle.bmc.announcementsservice.Service;
import com.oracle.bmc.announcementsservice.model.ServiceSummary;
import com.oracle.bmc.announcementsservice.requests.ListServicesRequest;
import com.oracle.bmc.announcementsservice.responses.ListServicesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServicePaginators {
    private final Service client;

    public ServicePaginators(Service client) {
        this.client = client;
    }

    public Iterable<ListServicesResponse> listServicesResponseIterator(final ListServicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListServicesRequest.Builder>(){

            @Override
            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServicesResponse, String>(){

            @Override
            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            @Override
            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServicesRequest, ListServicesResponse>(){

            @Override
            public ListServicesResponse apply(ListServicesRequest request) {
                return ServicePaginators.this.client.listServices(request);
            }
        });
    }

    public Iterable<ServiceSummary> listServicesRecordIterator(final ListServicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListServicesRequest.Builder>(){

            @Override
            public ListServicesRequest.Builder get() {
                return ListServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServicesResponse, String>(){

            @Override
            public String apply(ListServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServicesRequest.Builder>, ListServicesRequest>(){

            @Override
            public ListServicesRequest apply(RequestBuilderAndToken<ListServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServicesRequest, ListServicesResponse>(){

            @Override
            public ListServicesResponse apply(ListServicesRequest request) {
                return ServicePaginators.this.client.listServices(request);
            }
        }, (Function)new Function<ListServicesResponse, List<ServiceSummary>>(){

            @Override
            public List<ServiceSummary> apply(ListServicesResponse response) {
                return response.getServicesCollection().getItems();
            }
        });
    }
}

