/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.ApiGateway;
import com.oracle.bmc.apigateway.ApiGatewayPaginators;
import com.oracle.bmc.apigateway.ApiGatewayWaiters;
import com.oracle.bmc.apigateway.internal.http.ChangeApiCompartmentConverter;
import com.oracle.bmc.apigateway.internal.http.ChangeCertificateCompartmentConverter;
import com.oracle.bmc.apigateway.internal.http.CreateApiConverter;
import com.oracle.bmc.apigateway.internal.http.CreateCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.DeleteApiConverter;
import com.oracle.bmc.apigateway.internal.http.DeleteCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiContentConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiDeploymentSpecificationConverter;
import com.oracle.bmc.apigateway.internal.http.GetApiValidationsConverter;
import com.oracle.bmc.apigateway.internal.http.GetCertificateConverter;
import com.oracle.bmc.apigateway.internal.http.ListApisConverter;
import com.oracle.bmc.apigateway.internal.http.ListCertificatesConverter;
import com.oracle.bmc.apigateway.internal.http.UpdateApiConverter;
import com.oracle.bmc.apigateway.internal.http.UpdateCertificateConverter;
import com.oracle.bmc.apigateway.requests.ChangeApiCompartmentRequest;
import com.oracle.bmc.apigateway.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateApiRequest;
import com.oracle.bmc.apigateway.requests.CreateCertificateRequest;
import com.oracle.bmc.apigateway.requests.DeleteApiRequest;
import com.oracle.bmc.apigateway.requests.DeleteCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.requests.GetApiDeploymentSpecificationRequest;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetApiValidationsRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.UpdateApiRequest;
import com.oracle.bmc.apigateway.requests.UpdateCertificateRequest;
import com.oracle.bmc.apigateway.responses.ChangeApiCompartmentResponse;
import com.oracle.bmc.apigateway.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateApiResponse;
import com.oracle.bmc.apigateway.responses.CreateCertificateResponse;
import com.oracle.bmc.apigateway.responses.DeleteApiResponse;
import com.oracle.bmc.apigateway.responses.DeleteCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.apigateway.responses.GetApiDeploymentSpecificationResponse;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetApiValidationsResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.UpdateApiResponse;
import com.oracle.bmc.apigateway.responses.UpdateCertificateResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayClient
implements ApiGateway {
    private static final Logger LOG = LoggerFactory.getLogger(ApiGatewayClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APIGATEWAY").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ApiGatewayWaiters waiters;
    private final ApiGatewayPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ApiGatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ApiGatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ApiGatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected ApiGatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ApiGateway-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApiGatewayWaiters(executorService, this);
        this.paginators = new ApiGatewayPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeApiCompartmentResponse changeApiCompartment(ChangeApiCompartmentRequest request) {
        LOG.trace("Called changeApiCompartment");
        ChangeApiCompartmentRequest interceptedRequest = ChangeApiCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApiCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApiCompartmentResponse> transformer = ChangeApiCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeApiCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeApiCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeApiCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeApiCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeCertificateCompartmentResponse changeCertificateCompartment(ChangeCertificateCompartmentRequest request) {
        LOG.trace("Called changeCertificateCompartment");
        ChangeCertificateCompartmentRequest interceptedRequest = ChangeCertificateCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeCertificateCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeCertificateCompartmentResponse> transformer = ChangeCertificateCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeCertificateCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeCertificateCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeCertificateCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeCertificateCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateApiResponse createApi(CreateApiRequest request) {
        LOG.trace("Called createApi");
        CreateApiRequest interceptedRequest = CreateApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApiResponse> transformer = CreateApiConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateApiResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateApiResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateApiDetails(), (BmcRequest)retriedRequest);
                return (CreateApiResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateCertificateResponse createCertificate(CreateCertificateRequest request) {
        LOG.trace("Called createCertificate");
        CreateCertificateRequest interceptedRequest = CreateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateCertificateResponse> transformer = CreateCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateCertificateDetails(), (BmcRequest)retriedRequest);
                return (CreateCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApiResponse deleteApi(DeleteApiRequest request) {
        LOG.trace("Called deleteApi");
        DeleteApiRequest interceptedRequest = DeleteApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApiResponse> transformer = DeleteApiConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteApiResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteApiResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteApiResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest request) {
        LOG.trace("Called deleteCertificate");
        DeleteCertificateRequest interceptedRequest = DeleteCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteCertificateResponse> transformer = DeleteCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApiResponse getApi(GetApiRequest request) {
        LOG.trace("Called getApi");
        GetApiRequest interceptedRequest = GetApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiResponse> transformer = GetApiConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApiResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApiResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApiResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApiContentResponse getApiContent(GetApiContentRequest request) {
        LOG.trace("Called getApiContent");
        GetApiContentRequest interceptedRequest = GetApiContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiContentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiContentResponse> transformer = GetApiContentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApiContentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApiContentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApiContentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApiDeploymentSpecificationResponse getApiDeploymentSpecification(GetApiDeploymentSpecificationRequest request) {
        LOG.trace("Called getApiDeploymentSpecification");
        GetApiDeploymentSpecificationRequest interceptedRequest = GetApiDeploymentSpecificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiDeploymentSpecificationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiDeploymentSpecificationResponse> transformer = GetApiDeploymentSpecificationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApiDeploymentSpecificationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApiDeploymentSpecificationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApiDeploymentSpecificationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApiValidationsResponse getApiValidations(GetApiValidationsRequest request) {
        LOG.trace("Called getApiValidations");
        GetApiValidationsRequest interceptedRequest = GetApiValidationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApiValidationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApiValidationsResponse> transformer = GetApiValidationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApiValidationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApiValidationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApiValidationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetCertificateResponse getCertificate(GetCertificateRequest request) {
        LOG.trace("Called getCertificate");
        GetCertificateRequest interceptedRequest = GetCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetCertificateResponse> transformer = GetCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApisResponse listApis(ListApisRequest request) {
        LOG.trace("Called listApis");
        ListApisRequest interceptedRequest = ListApisConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApisConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApisResponse> transformer = ListApisConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApisResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApisResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApisResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest request) {
        LOG.trace("Called listCertificates");
        ListCertificatesRequest interceptedRequest = ListCertificatesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCertificatesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListCertificatesResponse> transformer = ListCertificatesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListCertificatesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListCertificatesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListCertificatesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateApiResponse updateApi(UpdateApiRequest request) {
        LOG.trace("Called updateApi");
        UpdateApiRequest interceptedRequest = UpdateApiConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApiConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApiResponse> transformer = UpdateApiConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateApiResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateApiResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateApiDetails(), (BmcRequest)retriedRequest);
                return (UpdateApiResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateCertificateResponse updateCertificate(UpdateCertificateRequest request) {
        LOG.trace("Called updateCertificate");
        UpdateCertificateRequest interceptedRequest = UpdateCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateCertificateResponse> transformer = UpdateCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateCertificateDetails(), (BmcRequest)retriedRequest);
                return (UpdateCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ApiGatewayWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApiGatewayPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApiGatewayClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApiGatewayClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new ApiGatewayClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

