/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.apigateway.Gateway;
import com.oracle.bmc.apigateway.model.GatewaySummary;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class GatewayPaginators {
    private final Gateway client;

    public Iterable<ListGatewaysResponse> listGatewaysResponseIterator(final ListGatewaysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGatewaysRequest.Builder>(){

            public ListGatewaysRequest.Builder get() {
                return ListGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGatewaysResponse, String>(){

            public String apply(ListGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGatewaysRequest.Builder>, ListGatewaysRequest>(){

            public ListGatewaysRequest apply(RequestBuilderAndToken<ListGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListGatewaysRequest, ListGatewaysResponse>(){

            public ListGatewaysResponse apply(ListGatewaysRequest request) {
                return GatewayPaginators.this.client.listGateways(request);
            }
        });
    }

    public Iterable<GatewaySummary> listGatewaysRecordIterator(final ListGatewaysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGatewaysRequest.Builder>(){

            public ListGatewaysRequest.Builder get() {
                return ListGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGatewaysResponse, String>(){

            public String apply(ListGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGatewaysRequest.Builder>, ListGatewaysRequest>(){

            public ListGatewaysRequest apply(RequestBuilderAndToken<ListGatewaysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListGatewaysRequest, ListGatewaysResponse>(){

            public ListGatewaysResponse apply(ListGatewaysRequest request) {
                return GatewayPaginators.this.client.listGateways(request);
            }
        }, (Function)new Function<ListGatewaysResponse, List<GatewaySummary>>(){

            public List<GatewaySummary> apply(ListGatewaysResponse response) {
                return response.getGatewayCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public GatewayPaginators(Gateway client) {
        this.client = client;
    }
}

