/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetGatewayRequest
extends BmcRequest<Void> {
    private String gatewayId;
    private String opcRequestId;

    @ConstructorProperties(value={"gatewayId", "opcRequestId"})
    GetGatewayRequest(String gatewayId, String opcRequestId) {
        this.gatewayId = gatewayId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGatewayRequest, Void> {
        private String gatewayId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGatewayRequest o) {
            this.gatewayId(o.getGatewayId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGatewayRequest build() {
            GetGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetGatewayRequest buildWithoutInvocationCallback() {
            return new GetGatewayRequest(this.gatewayId, this.opcRequestId);
        }

        public String toString() {
            return "GetGatewayRequest.Builder(gatewayId=" + this.gatewayId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

