/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Gateway;
import com.oracle.bmc.apigateway.model.Gateway;
import com.oracle.bmc.apigateway.requests.GetGatewayRequest;
import com.oracle.bmc.apigateway.responses.GetGatewayResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class GatewayWaiters {
    private final ExecutorService executorService;
    private final Gateway client;

    public GatewayWaiters(ExecutorService executorService, Gateway client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetGatewayRequest, GetGatewayResponse> forGateway(GetGatewayRequest request, Gateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGatewayRequest, GetGatewayResponse> forGateway(GetGatewayRequest request, Gateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGatewayRequest, GetGatewayResponse> forGateway(GetGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Gateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGatewayRequest, GetGatewayResponse> forGateway(BmcGenericWaiter waiter, GetGatewayRequest request, Gateway.LifecycleState ... targetStates) {
        final HashSet<Gateway.LifecycleState> targetStatesSet = new HashSet<Gateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetGatewayRequest, GetGatewayResponse>(){

            @Override
            public GetGatewayResponse apply(GetGatewayRequest request) {
                return GatewayWaiters.this.client.getGateway(request);
            }
        }, (Predicate)new Predicate<GetGatewayResponse>(){

            @Override
            public boolean test(GetGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Gateway.LifecycleState.Deleted)), (Object)request);
    }
}

