/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Subscribers;
import com.oracle.bmc.apigateway.model.Subscriber;
import com.oracle.bmc.apigateway.requests.GetSubscriberRequest;
import com.oracle.bmc.apigateway.responses.GetSubscriberResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class SubscribersWaiters {
    private final ExecutorService executorService;
    private final Subscribers client;

    public SubscribersWaiters(ExecutorService executorService, Subscribers client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetSubscriberRequest, GetSubscriberResponse> forSubscriber(GetSubscriberRequest request, Subscriber.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSubscriber(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSubscriberRequest, GetSubscriberResponse> forSubscriber(GetSubscriberRequest request, Subscriber.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSubscriber(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSubscriberRequest, GetSubscriberResponse> forSubscriber(GetSubscriberRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Subscriber.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSubscriber(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSubscriberRequest, GetSubscriberResponse> forSubscriber(BmcGenericWaiter waiter, GetSubscriberRequest request, Subscriber.LifecycleState ... targetStates) {
        final HashSet<Subscriber.LifecycleState> targetStatesSet = new HashSet<Subscriber.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSubscriberRequest, GetSubscriberResponse>(){

            @Override
            public GetSubscriberResponse apply(GetSubscriberRequest request) {
                return SubscribersWaiters.this.client.getSubscriber(request);
            }
        }, (Predicate)new Predicate<GetSubscriberResponse>(){

            @Override
            public boolean test(GetSubscriberResponse response) {
                return targetStatesSet.contains((Object)response.getSubscriber().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Subscriber.LifecycleState.Deleted)), (Object)request);
    }
}

