/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.UsagePlans;
import com.oracle.bmc.apigateway.model.UsagePlanSummary;
import com.oracle.bmc.apigateway.requests.ListUsagePlansRequest;
import com.oracle.bmc.apigateway.responses.ListUsagePlansResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class UsagePlansPaginators {
    private final UsagePlans client;

    public UsagePlansPaginators(UsagePlans client) {
        this.client = client;
    }

    public Iterable<ListUsagePlansResponse> listUsagePlansResponseIterator(final ListUsagePlansRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListUsagePlansRequest.Builder>(){

            @Override
            public ListUsagePlansRequest.Builder get() {
                return ListUsagePlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsagePlansResponse, String>(){

            @Override
            public String apply(ListUsagePlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsagePlansRequest.Builder>, ListUsagePlansRequest>(){

            @Override
            public ListUsagePlansRequest apply(RequestBuilderAndToken<ListUsagePlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsagePlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsagePlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsagePlansRequest, ListUsagePlansResponse>(){

            @Override
            public ListUsagePlansResponse apply(ListUsagePlansRequest request) {
                return UsagePlansPaginators.this.client.listUsagePlans(request);
            }
        });
    }

    public Iterable<UsagePlanSummary> listUsagePlansRecordIterator(final ListUsagePlansRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListUsagePlansRequest.Builder>(){

            @Override
            public ListUsagePlansRequest.Builder get() {
                return ListUsagePlansRequest.builder().copy(request);
            }
        }, (Function)new Function<ListUsagePlansResponse, String>(){

            @Override
            public String apply(ListUsagePlansResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListUsagePlansRequest.Builder>, ListUsagePlansRequest>(){

            @Override
            public ListUsagePlansRequest apply(RequestBuilderAndToken<ListUsagePlansRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListUsagePlansRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListUsagePlansRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListUsagePlansRequest, ListUsagePlansResponse>(){

            @Override
            public ListUsagePlansResponse apply(ListUsagePlansRequest request) {
                return UsagePlansPaginators.this.client.listUsagePlans(request);
            }
        }, (Function)new Function<ListUsagePlansResponse, List<UsagePlanSummary>>(){

            @Override
            public List<UsagePlanSummary> apply(ListUsagePlansResponse response) {
                return response.getUsagePlanCollection().getItems();
            }
        });
    }
}

