/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Quota
extends ExplicitlySetBmcModel {
    @JsonProperty(value="value")
    private final Integer value;
    @JsonProperty(value="unit")
    private final Unit unit;
    @JsonProperty(value="resetPolicy")
    private final ResetPolicy resetPolicy;
    @JsonProperty(value="operationOnBreach")
    private final OperationOnBreach operationOnBreach;

    @Deprecated
    @ConstructorProperties(value={"value", "unit", "resetPolicy", "operationOnBreach"})
    public Quota(Integer value, Unit unit, ResetPolicy resetPolicy, OperationOnBreach operationOnBreach) {
        this.value = value;
        this.unit = unit;
        this.resetPolicy = resetPolicy;
        this.operationOnBreach = operationOnBreach;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public ResetPolicy getResetPolicy() {
        return this.resetPolicy;
    }

    public OperationOnBreach getOperationOnBreach() {
        return this.operationOnBreach;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Quota(");
        sb.append("super=").append(super.toString());
        sb.append("value=").append(String.valueOf(this.value));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(", resetPolicy=").append(String.valueOf((Object)this.resetPolicy));
        sb.append(", operationOnBreach=").append(String.valueOf((Object)this.operationOnBreach));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quota)) {
            return false;
        }
        Quota other = (Quota)((Object)o);
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals((Object)this.resetPolicy, (Object)other.resetPolicy) && Objects.equals((Object)this.operationOnBreach, (Object)other.operationOnBreach) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.resetPolicy == null ? 43 : this.resetPolicy.hashCode());
        result = result * 59 + (this.operationOnBreach == null ? 43 : this.operationOnBreach.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OperationOnBreach implements BmcEnum
    {
        Reject("REJECT"),
        Allow("ALLOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationOnBreach> map;

        private OperationOnBreach(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationOnBreach create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationOnBreach', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationOnBreach.class);
            map = new HashMap<String, OperationOnBreach>();
            for (OperationOnBreach v : OperationOnBreach.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResetPolicy implements BmcEnum
    {
        Calendar("CALENDAR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResetPolicy> map;

        private ResetPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResetPolicy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResetPolicy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResetPolicy.class);
            map = new HashMap<String, ResetPolicy>();
            for (ResetPolicy v : ResetPolicy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Unit implements BmcEnum
    {
        Minute("MINUTE"),
        Hour("HOUR"),
        Day("DAY"),
        Week("WEEK"),
        Month("MONTH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Unit> map;

        private Unit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Unit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Unit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Unit.class);
            map = new HashMap<String, Unit>();
            for (Unit v : Unit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="value")
        private Integer value;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonProperty(value="resetPolicy")
        private ResetPolicy resetPolicy;
        @JsonProperty(value="operationOnBreach")
        private OperationOnBreach operationOnBreach;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder value(Integer value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder resetPolicy(ResetPolicy resetPolicy) {
            this.resetPolicy = resetPolicy;
            this.__explicitlySet__.add("resetPolicy");
            return this;
        }

        public Builder operationOnBreach(OperationOnBreach operationOnBreach) {
            this.operationOnBreach = operationOnBreach;
            this.__explicitlySet__.add("operationOnBreach");
            return this;
        }

        public Quota build() {
            Quota model = new Quota(this.value, this.unit, this.resetPolicy, this.operationOnBreach);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Quota model) {
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("resetPolicy")) {
                this.resetPolicy(model.getResetPolicy());
            }
            if (model.wasPropertyExplicitlySet("operationOnBreach")) {
                this.operationOnBreach(model.getOperationOnBreach());
            }
            return this;
        }
    }
}

