/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.apigateway.model.PublicKeySet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RemoteJsonWebKeySet
extends PublicKeySet {
    @JsonProperty(value="uri")
    private final String uri;
    @JsonProperty(value="isSslVerifyDisabled")
    private final Boolean isSslVerifyDisabled;
    @JsonProperty(value="maxCacheDurationInHours")
    private final Integer maxCacheDurationInHours;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RemoteJsonWebKeySet(String uri, Boolean isSslVerifyDisabled, Integer maxCacheDurationInHours) {
        this.uri = uri;
        this.isSslVerifyDisabled = isSslVerifyDisabled;
        this.maxCacheDurationInHours = maxCacheDurationInHours;
    }

    public String getUri() {
        return this.uri;
    }

    public Boolean getIsSslVerifyDisabled() {
        return this.isSslVerifyDisabled;
    }

    public Integer getMaxCacheDurationInHours() {
        return this.maxCacheDurationInHours;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RemoteJsonWebKeySet(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", uri=").append(String.valueOf(this.uri));
        sb.append(", isSslVerifyDisabled=").append(String.valueOf(this.isSslVerifyDisabled));
        sb.append(", maxCacheDurationInHours=").append(String.valueOf(this.maxCacheDurationInHours));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteJsonWebKeySet)) {
            return false;
        }
        RemoteJsonWebKeySet other = (RemoteJsonWebKeySet)((Object)o);
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.isSslVerifyDisabled, other.isSslVerifyDisabled) && Objects.equals(this.maxCacheDurationInHours, other.maxCacheDurationInHours) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + (this.isSslVerifyDisabled == null ? 43 : this.isSslVerifyDisabled.hashCode());
        result = result * 59 + (this.maxCacheDurationInHours == null ? 43 : this.maxCacheDurationInHours.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="isSslVerifyDisabled")
        private Boolean isSslVerifyDisabled;
        @JsonProperty(value="maxCacheDurationInHours")
        private Integer maxCacheDurationInHours;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public Builder isSslVerifyDisabled(Boolean isSslVerifyDisabled) {
            this.isSslVerifyDisabled = isSslVerifyDisabled;
            this.__explicitlySet__.add("isSslVerifyDisabled");
            return this;
        }

        public Builder maxCacheDurationInHours(Integer maxCacheDurationInHours) {
            this.maxCacheDurationInHours = maxCacheDurationInHours;
            this.__explicitlySet__.add("maxCacheDurationInHours");
            return this;
        }

        public RemoteJsonWebKeySet build() {
            RemoteJsonWebKeySet model = new RemoteJsonWebKeySet(this.uri, this.isSslVerifyDisabled, this.maxCacheDurationInHours);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RemoteJsonWebKeySet model) {
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            if (model.wasPropertyExplicitlySet("isSslVerifyDisabled")) {
                this.isSslVerifyDisabled(model.getIsSslVerifyDisabled());
            }
            if (model.wasPropertyExplicitlySet("maxCacheDurationInHours")) {
                this.maxCacheDurationInHours(model.getMaxCacheDurationInHours());
            }
            return this;
        }
    }
}

