/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.apigateway.model.ChangeApiCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeApiCompartmentRequest
extends BmcRequest<ChangeApiCompartmentDetails> {
    private String apiId;
    private ChangeApiCompartmentDetails changeApiCompartmentDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getApiId() {
        return this.apiId;
    }

    public ChangeApiCompartmentDetails getChangeApiCompartmentDetails() {
        return this.changeApiCompartmentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeApiCompartmentDetails getBody$() {
        return this.changeApiCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().apiId(this.apiId).changeApiCompartmentDetails(this.changeApiCompartmentDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",apiId=").append(String.valueOf(this.apiId));
        sb.append(",changeApiCompartmentDetails=").append(String.valueOf((Object)this.changeApiCompartmentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeApiCompartmentRequest)) {
            return false;
        }
        ChangeApiCompartmentRequest other = (ChangeApiCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.apiId, other.apiId) && Objects.equals((Object)this.changeApiCompartmentDetails, (Object)other.changeApiCompartmentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.apiId == null ? 43 : this.apiId.hashCode());
        result = result * 59 + (this.changeApiCompartmentDetails == null ? 43 : this.changeApiCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeApiCompartmentRequest, ChangeApiCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String apiId = null;
        private ChangeApiCompartmentDetails changeApiCompartmentDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public Builder changeApiCompartmentDetails(ChangeApiCompartmentDetails changeApiCompartmentDetails) {
            this.changeApiCompartmentDetails = changeApiCompartmentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeApiCompartmentRequest o) {
            this.apiId(o.getApiId());
            this.changeApiCompartmentDetails(o.getChangeApiCompartmentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeApiCompartmentRequest build() {
            ChangeApiCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeApiCompartmentDetails body) {
            this.changeApiCompartmentDetails(body);
            return this;
        }

        public ChangeApiCompartmentRequest buildWithoutInvocationCallback() {
            ChangeApiCompartmentRequest request = new ChangeApiCompartmentRequest();
            request.apiId = this.apiId;
            request.changeApiCompartmentDetails = this.changeApiCompartmentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

