/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.ApiGateway;
import com.oracle.bmc.apigateway.model.ApiSummary;
import com.oracle.bmc.apigateway.model.CertificateSummary;
import com.oracle.bmc.apigateway.model.SdkLanguageTypeSummary;
import com.oracle.bmc.apigateway.model.SdkSummary;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.ListSdkLanguageTypesRequest;
import com.oracle.bmc.apigateway.requests.ListSdksRequest;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.ListSdkLanguageTypesResponse;
import com.oracle.bmc.apigateway.responses.ListSdksResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ApiGatewayPaginators {
    private final ApiGateway client;

    public ApiGatewayPaginators(ApiGateway client) {
        this.client = client;
    }

    public Iterable<ListApisResponse> listApisResponseIterator(final ListApisRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApisRequest.Builder>(){

            @Override
            public ListApisRequest.Builder get() {
                return ListApisRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApisResponse, String>(){

            @Override
            public String apply(ListApisResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApisRequest.Builder>, ListApisRequest>(){

            @Override
            public ListApisRequest apply(RequestBuilderAndToken<ListApisRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApisRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApisRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApisRequest, ListApisResponse>(){

            @Override
            public ListApisResponse apply(ListApisRequest request) {
                return ApiGatewayPaginators.this.client.listApis(request);
            }
        });
    }

    public Iterable<ApiSummary> listApisRecordIterator(final ListApisRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApisRequest.Builder>(){

            @Override
            public ListApisRequest.Builder get() {
                return ListApisRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApisResponse, String>(){

            @Override
            public String apply(ListApisResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApisRequest.Builder>, ListApisRequest>(){

            @Override
            public ListApisRequest apply(RequestBuilderAndToken<ListApisRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApisRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApisRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApisRequest, ListApisResponse>(){

            @Override
            public ListApisResponse apply(ListApisRequest request) {
                return ApiGatewayPaginators.this.client.listApis(request);
            }
        }, (Function)new Function<ListApisResponse, List<ApiSummary>>(){

            @Override
            public List<ApiSummary> apply(ListApisResponse response) {
                return response.getApiCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificatesResponse> listCertificatesResponseIterator(final ListCertificatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return ApiGatewayPaginators.this.client.listCertificates(request);
            }
        });
    }

    public Iterable<CertificateSummary> listCertificatesRecordIterator(final ListCertificatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return ApiGatewayPaginators.this.client.listCertificates(request);
            }
        }, (Function)new Function<ListCertificatesResponse, List<CertificateSummary>>(){

            @Override
            public List<CertificateSummary> apply(ListCertificatesResponse response) {
                return response.getCertificateCollection().getItems();
            }
        });
    }

    public Iterable<ListSdkLanguageTypesResponse> listSdkLanguageTypesResponseIterator(final ListSdkLanguageTypesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSdkLanguageTypesRequest.Builder>(){

            @Override
            public ListSdkLanguageTypesRequest.Builder get() {
                return ListSdkLanguageTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSdkLanguageTypesResponse, String>(){

            @Override
            public String apply(ListSdkLanguageTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSdkLanguageTypesRequest.Builder>, ListSdkLanguageTypesRequest>(){

            @Override
            public ListSdkLanguageTypesRequest apply(RequestBuilderAndToken<ListSdkLanguageTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSdkLanguageTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSdkLanguageTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSdkLanguageTypesRequest, ListSdkLanguageTypesResponse>(){

            @Override
            public ListSdkLanguageTypesResponse apply(ListSdkLanguageTypesRequest request) {
                return ApiGatewayPaginators.this.client.listSdkLanguageTypes(request);
            }
        });
    }

    public Iterable<SdkLanguageTypeSummary> listSdkLanguageTypesRecordIterator(final ListSdkLanguageTypesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSdkLanguageTypesRequest.Builder>(){

            @Override
            public ListSdkLanguageTypesRequest.Builder get() {
                return ListSdkLanguageTypesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSdkLanguageTypesResponse, String>(){

            @Override
            public String apply(ListSdkLanguageTypesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSdkLanguageTypesRequest.Builder>, ListSdkLanguageTypesRequest>(){

            @Override
            public ListSdkLanguageTypesRequest apply(RequestBuilderAndToken<ListSdkLanguageTypesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSdkLanguageTypesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSdkLanguageTypesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSdkLanguageTypesRequest, ListSdkLanguageTypesResponse>(){

            @Override
            public ListSdkLanguageTypesResponse apply(ListSdkLanguageTypesRequest request) {
                return ApiGatewayPaginators.this.client.listSdkLanguageTypes(request);
            }
        }, (Function)new Function<ListSdkLanguageTypesResponse, List<SdkLanguageTypeSummary>>(){

            @Override
            public List<SdkLanguageTypeSummary> apply(ListSdkLanguageTypesResponse response) {
                return response.getSdkLanguageTypeCollection().getItems();
            }
        });
    }

    public Iterable<ListSdksResponse> listSdksResponseIterator(final ListSdksRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSdksRequest.Builder>(){

            @Override
            public ListSdksRequest.Builder get() {
                return ListSdksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSdksResponse, String>(){

            @Override
            public String apply(ListSdksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSdksRequest.Builder>, ListSdksRequest>(){

            @Override
            public ListSdksRequest apply(RequestBuilderAndToken<ListSdksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSdksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSdksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSdksRequest, ListSdksResponse>(){

            @Override
            public ListSdksResponse apply(ListSdksRequest request) {
                return ApiGatewayPaginators.this.client.listSdks(request);
            }
        });
    }

    public Iterable<SdkSummary> listSdksRecordIterator(final ListSdksRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSdksRequest.Builder>(){

            @Override
            public ListSdksRequest.Builder get() {
                return ListSdksRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSdksResponse, String>(){

            @Override
            public String apply(ListSdksResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSdksRequest.Builder>, ListSdksRequest>(){

            @Override
            public ListSdksRequest apply(RequestBuilderAndToken<ListSdksRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSdksRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSdksRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSdksRequest, ListSdksResponse>(){

            @Override
            public ListSdksResponse apply(ListSdksRequest request) {
                return ApiGatewayPaginators.this.client.listSdks(request);
            }
        }, (Function)new Function<ListSdksResponse, List<SdkSummary>>(){

            @Override
            public List<SdkSummary> apply(ListSdksResponse response) {
                return response.getSdkCollection().getItems();
            }
        });
    }
}

