/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.Deployment;
import com.oracle.bmc.apigateway.DeploymentPaginators;
import com.oracle.bmc.apigateway.DeploymentWaiters;
import com.oracle.bmc.apigateway.model.DeploymentCollection;
import com.oracle.bmc.apigateway.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateDeploymentRequest;
import com.oracle.bmc.apigateway.requests.DeleteDeploymentRequest;
import com.oracle.bmc.apigateway.requests.GetDeploymentRequest;
import com.oracle.bmc.apigateway.requests.ListDeploymentsRequest;
import com.oracle.bmc.apigateway.requests.UpdateDeploymentRequest;
import com.oracle.bmc.apigateway.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateDeploymentResponse;
import com.oracle.bmc.apigateway.responses.DeleteDeploymentResponse;
import com.oracle.bmc.apigateway.responses.GetDeploymentResponse;
import com.oracle.bmc.apigateway.responses.ListDeploymentsResponse;
import com.oracle.bmc.apigateway.responses.UpdateDeploymentResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentClient
extends BaseSyncClient
implements Deployment {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEPLOYMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentClient.class);
    private final DeploymentWaiters waiters;
    private final DeploymentPaginators paginators;

    DeploymentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Deployment-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DeploymentWaiters(executorService, this);
        this.paginators = new DeploymentPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeDeploymentCompartmentResponse changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDeploymentCompartmentDetails(), "changeDeploymentCompartmentDetails is required");
        return (ChangeDeploymentCompartmentResponse)this.clientCall(request, ChangeDeploymentCompartmentResponse::builder).logger(LOG, "changeDeploymentCompartment").serviceDetails("Deployment", "ChangeDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Deployment/ChangeDeploymentCompartment").method(Method.POST).requestBuilder(ChangeDeploymentCompartmentRequest::builder).basePath("/20190501").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDeploymentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDeploymentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest request) {
        Objects.requireNonNull(request.getCreateDeploymentDetails(), "createDeploymentDetails is required");
        return (CreateDeploymentResponse)this.clientCall(request, CreateDeploymentResponse::builder).logger(LOG, "createDeployment").serviceDetails("Deployment", "CreateDeployment", "").method(Method.POST).requestBuilder(CreateDeploymentRequest::builder).basePath("/20190501").appendPathParam("deployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.apigateway.model.Deployment.class, CreateDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", CreateDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateDeploymentResponse.Builder::location).callSync();
    }

    @Override
    public DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (DeleteDeploymentResponse)this.clientCall(request, DeleteDeploymentResponse::builder).logger(LOG, "deleteDeployment").serviceDetails("Deployment", "DeleteDeployment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Deployment/DeleteDeployment").method(Method.DELETE).requestBuilder(DeleteDeploymentRequest::builder).basePath("/20190501").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (GetDeploymentResponse)this.clientCall(request, GetDeploymentResponse::builder).logger(LOG, "getDeployment").serviceDetails("Deployment", "GetDeployment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Deployment/GetDeployment").method(Method.GET).requestBuilder(GetDeploymentRequest::builder).basePath("/20190501").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.apigateway.model.Deployment.class, GetDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", GetDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDeploymentsResponse)this.clientCall(request, ListDeploymentsResponse::builder).logger(LOG, "listDeployments").serviceDetails("Deployment", "ListDeployments", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/DeploymentSummary/ListDeployments").method(Method.GET).requestBuilder(ListDeploymentsRequest::builder).basePath("/20190501").appendPathParam("deployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("gatewayId", (Object)request.getGatewayId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentCollection.class, ListDeploymentsResponse.Builder::deploymentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListDeploymentsResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentDetails(), "updateDeploymentDetails is required");
        return (UpdateDeploymentResponse)this.clientCall(request, UpdateDeploymentResponse::builder).logger(LOG, "updateDeployment").serviceDetails("Deployment", "UpdateDeployment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Deployment/UpdateDeployment").method(Method.PUT).requestBuilder(UpdateDeploymentRequest::builder).basePath("/20190501").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeploymentWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DeploymentPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DeploymentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DeploymentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DeploymentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DeploymentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DeploymentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DeploymentClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "apigateway";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apigateway");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DeploymentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DeploymentClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

