/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Deployment;
import com.oracle.bmc.apigateway.model.Deployment;
import com.oracle.bmc.apigateway.requests.GetDeploymentRequest;
import com.oracle.bmc.apigateway.responses.GetDeploymentResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DeploymentWaiters {
    private final ExecutorService executorService;
    private final Deployment client;

    public DeploymentWaiters(ExecutorService executorService, Deployment client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, Deployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, Deployment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Deployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(BmcGenericWaiter waiter, GetDeploymentRequest request, Deployment.LifecycleState ... targetStates) {
        final HashSet<Deployment.LifecycleState> targetStatesSet = new HashSet<Deployment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDeploymentRequest, GetDeploymentResponse>(){

            @Override
            public GetDeploymentResponse apply(GetDeploymentRequest request) {
                return DeploymentWaiters.this.client.getDeployment(request);
            }
        }, (Predicate)new Predicate<GetDeploymentResponse>(){

            @Override
            public boolean test(GetDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Deployment.LifecycleState.Deleted)), (Object)request);
    }
}

