/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.GatewayPaginators;
import com.oracle.bmc.apigateway.GatewayWaiters;
import com.oracle.bmc.apigateway.model.Gateway;
import com.oracle.bmc.apigateway.model.GatewayCollection;
import com.oracle.bmc.apigateway.requests.ChangeGatewayCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateGatewayRequest;
import com.oracle.bmc.apigateway.requests.DeleteGatewayRequest;
import com.oracle.bmc.apigateway.requests.GetGatewayRequest;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.requests.UpdateGatewayRequest;
import com.oracle.bmc.apigateway.responses.ChangeGatewayCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateGatewayResponse;
import com.oracle.bmc.apigateway.responses.DeleteGatewayResponse;
import com.oracle.bmc.apigateway.responses.GetGatewayResponse;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.apigateway.responses.UpdateGatewayResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayClient
extends BaseSyncClient
implements com.oracle.bmc.apigateway.Gateway {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GATEWAY").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GatewayClient.class);
    private final GatewayWaiters waiters;
    private final GatewayPaginators paginators;

    GatewayClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Gateway-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new GatewayWaiters(executorService, this);
        this.paginators = new GatewayPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeGatewayCompartmentResponse changeGatewayCompartment(ChangeGatewayCompartmentRequest request) {
        Validate.notBlank((String)request.getGatewayId(), (String)"gatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeGatewayCompartmentDetails(), "changeGatewayCompartmentDetails is required");
        return (ChangeGatewayCompartmentResponse)this.clientCall(request, ChangeGatewayCompartmentResponse::builder).logger(LOG, "changeGatewayCompartment").serviceDetails("Gateway", "ChangeGatewayCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Gateway/ChangeGatewayCompartment").method(Method.POST).requestBuilder(ChangeGatewayCompartmentRequest::builder).basePath("/20190501").appendPathParam("gateways").appendPathParam(request.getGatewayId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeGatewayCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeGatewayCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest request) {
        Objects.requireNonNull(request.getCreateGatewayDetails(), "createGatewayDetails is required");
        return (CreateGatewayResponse)this.clientCall(request, CreateGatewayResponse::builder).logger(LOG, "createGateway").serviceDetails("Gateway", "CreateGateway", "").method(Method.POST).requestBuilder(CreateGatewayRequest::builder).basePath("/20190501").appendPathParam("gateways").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Gateway.class, CreateGatewayResponse.Builder::gateway).handleResponseHeaderString("etag", CreateGatewayResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateGatewayResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateGatewayResponse.Builder::location).callSync();
    }

    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest request) {
        Validate.notBlank((String)request.getGatewayId(), (String)"gatewayId must not be blank", (Object[])new Object[0]);
        return (DeleteGatewayResponse)this.clientCall(request, DeleteGatewayResponse::builder).logger(LOG, "deleteGateway").serviceDetails("Gateway", "DeleteGateway", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Gateway/DeleteGateway").method(Method.DELETE).requestBuilder(DeleteGatewayRequest::builder).basePath("/20190501").appendPathParam("gateways").appendPathParam(request.getGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetGatewayResponse getGateway(GetGatewayRequest request) {
        Validate.notBlank((String)request.getGatewayId(), (String)"gatewayId must not be blank", (Object[])new Object[0]);
        return (GetGatewayResponse)this.clientCall(request, GetGatewayResponse::builder).logger(LOG, "getGateway").serviceDetails("Gateway", "GetGateway", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Gateway/GetGateway").method(Method.GET).requestBuilder(GetGatewayRequest::builder).basePath("/20190501").appendPathParam("gateways").appendPathParam(request.getGatewayId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Gateway.class, GetGatewayResponse.Builder::gateway).handleResponseHeaderString("etag", GetGatewayResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListGatewaysResponse)this.clientCall(request, ListGatewaysResponse::builder).logger(LOG, "listGateways").serviceDetails("Gateway", "ListGateways", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/GatewaySummary/ListGateways").method(Method.GET).requestBuilder(ListGatewaysRequest::builder).basePath("/20190501").appendPathParam("gateways").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("certificateId", (Object)request.getCertificateId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(GatewayCollection.class, ListGatewaysResponse.Builder::gatewayCollection).handleResponseHeaderString("opc-request-id", ListGatewaysResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGatewaysResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListGatewaysResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public UpdateGatewayResponse updateGateway(UpdateGatewayRequest request) {
        Validate.notBlank((String)request.getGatewayId(), (String)"gatewayId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateGatewayDetails(), "updateGatewayDetails is required");
        return (UpdateGatewayResponse)this.clientCall(request, UpdateGatewayResponse::builder).logger(LOG, "updateGateway").serviceDetails("Gateway", "UpdateGateway", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Gateway/UpdateGateway").method(Method.PUT).requestBuilder(UpdateGatewayRequest::builder).basePath("/20190501").appendPathParam("gateways").appendPathParam(request.getGatewayId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateGatewayResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGatewayResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GatewayWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public GatewayPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public GatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GatewayClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GatewayClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public GatewayClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GatewayClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GatewayClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "apigateway";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apigateway");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public GatewayClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GatewayClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

