/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.apigateway.Gateway;
import com.oracle.bmc.apigateway.model.GatewaySummary;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class GatewayPaginators {
    private final Gateway client;

    public GatewayPaginators(Gateway client) {
        this.client = client;
    }

    public Iterable<ListGatewaysResponse> listGatewaysResponseIterator(final ListGatewaysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGatewaysRequest.Builder>(){

            @Override
            public ListGatewaysRequest.Builder get() {
                return ListGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGatewaysResponse, String>(){

            @Override
            public String apply(ListGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGatewaysRequest.Builder>, ListGatewaysRequest>(){

            @Override
            public ListGatewaysRequest apply(RequestBuilderAndToken<ListGatewaysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGatewaysRequest, ListGatewaysResponse>(){

            @Override
            public ListGatewaysResponse apply(ListGatewaysRequest request) {
                return GatewayPaginators.this.client.listGateways(request);
            }
        });
    }

    public Iterable<GatewaySummary> listGatewaysRecordIterator(final ListGatewaysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGatewaysRequest.Builder>(){

            @Override
            public ListGatewaysRequest.Builder get() {
                return ListGatewaysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGatewaysResponse, String>(){

            @Override
            public String apply(ListGatewaysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGatewaysRequest.Builder>, ListGatewaysRequest>(){

            @Override
            public ListGatewaysRequest apply(RequestBuilderAndToken<ListGatewaysRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGatewaysRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGatewaysRequest, ListGatewaysResponse>(){

            @Override
            public ListGatewaysResponse apply(ListGatewaysRequest request) {
                return GatewayPaginators.this.client.listGateways(request);
            }
        }, (Function)new Function<ListGatewaysResponse, List<GatewaySummary>>(){

            @Override
            public List<GatewaySummary> apply(ListGatewaysResponse response) {
                return response.getGatewayCollection().getItems();
            }
        });
    }
}

