/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.Subscribers;
import com.oracle.bmc.apigateway.SubscribersPaginators;
import com.oracle.bmc.apigateway.SubscribersWaiters;
import com.oracle.bmc.apigateway.model.Subscriber;
import com.oracle.bmc.apigateway.model.SubscriberCollection;
import com.oracle.bmc.apigateway.requests.ChangeSubscriberCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateSubscriberRequest;
import com.oracle.bmc.apigateway.requests.DeleteSubscriberRequest;
import com.oracle.bmc.apigateway.requests.GetSubscriberRequest;
import com.oracle.bmc.apigateway.requests.ListSubscribersRequest;
import com.oracle.bmc.apigateway.requests.UpdateSubscriberRequest;
import com.oracle.bmc.apigateway.responses.ChangeSubscriberCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateSubscriberResponse;
import com.oracle.bmc.apigateway.responses.DeleteSubscriberResponse;
import com.oracle.bmc.apigateway.responses.GetSubscriberResponse;
import com.oracle.bmc.apigateway.responses.ListSubscribersResponse;
import com.oracle.bmc.apigateway.responses.UpdateSubscriberResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribersClient
extends BaseSyncClient
implements Subscribers {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SUBSCRIBERS").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SubscribersClient.class);
    private final SubscribersWaiters waiters;
    private final SubscribersPaginators paginators;

    SubscribersClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Subscribers-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new SubscribersWaiters(executorService, this);
        this.paginators = new SubscribersPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeSubscriberCompartmentResponse changeSubscriberCompartment(ChangeSubscriberCompartmentRequest request) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeSubscriberCompartmentDetails(), "changeSubscriberCompartmentDetails is required");
        return (ChangeSubscriberCompartmentResponse)this.clientCall(request, ChangeSubscriberCompartmentResponse::builder).logger(LOG, "changeSubscriberCompartment").serviceDetails("Subscribers", "ChangeSubscriberCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/ChangeSubscriberCompartment").method(Method.POST).requestBuilder(ChangeSubscriberCompartmentRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeSubscriberCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeSubscriberCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateSubscriberResponse createSubscriber(CreateSubscriberRequest request) {
        Objects.requireNonNull(request.getCreateSubscriberDetails(), "createSubscriberDetails is required");
        return (CreateSubscriberResponse)this.clientCall(request, CreateSubscriberResponse::builder).logger(LOG, "createSubscriber").serviceDetails("Subscribers", "CreateSubscriber", "").method(Method.POST).requestBuilder(CreateSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Subscriber.class, CreateSubscriberResponse.Builder::subscriber).handleResponseHeaderString("etag", CreateSubscriberResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateSubscriberResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateSubscriberResponse.Builder::location).callSync();
    }

    @Override
    public DeleteSubscriberResponse deleteSubscriber(DeleteSubscriberRequest request) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        return (DeleteSubscriberResponse)this.clientCall(request, DeleteSubscriberResponse::builder).logger(LOG, "deleteSubscriber").serviceDetails("Subscribers", "DeleteSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/DeleteSubscriber").method(Method.DELETE).requestBuilder(DeleteSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteSubscriberResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetSubscriberResponse getSubscriber(GetSubscriberRequest request) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        return (GetSubscriberResponse)this.clientCall(request, GetSubscriberResponse::builder).logger(LOG, "getSubscriber").serviceDetails("Subscribers", "GetSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/GetSubscriber").method(Method.GET).requestBuilder(GetSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Subscriber.class, GetSubscriberResponse.Builder::subscriber).handleResponseHeaderString("etag", GetSubscriberResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetSubscriberResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListSubscribersResponse listSubscribers(ListSubscribersRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListSubscribersResponse)this.clientCall(request, ListSubscribersResponse::builder).logger(LOG, "listSubscribers").serviceDetails("Subscribers", "ListSubscribers", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/ListSubscribers").method(Method.GET).requestBuilder(ListSubscribersRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(SubscriberCollection.class, ListSubscribersResponse.Builder::subscriberCollection).handleResponseHeaderString("opc-request-id", ListSubscribersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListSubscribersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListSubscribersResponse.Builder::opcPrevPage).callSync();
    }

    @Override
    public UpdateSubscriberResponse updateSubscriber(UpdateSubscriberRequest request) {
        Validate.notBlank((String)request.getSubscriberId(), (String)"subscriberId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateSubscriberDetails(), "updateSubscriberDetails is required");
        return (UpdateSubscriberResponse)this.clientCall(request, UpdateSubscriberResponse::builder).logger(LOG, "updateSubscriber").serviceDetails("Subscribers", "UpdateSubscriber", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/Subscriber/UpdateSubscriber").method(Method.PUT).requestBuilder(UpdateSubscriberRequest::builder).basePath("/20190501").appendPathParam("subscribers").appendPathParam(request.getSubscriberId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateSubscriberResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateSubscriberResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SubscribersWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public SubscribersPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public SubscribersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SubscribersClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SubscribersClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public SubscribersClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscribersClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SubscribersClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "apigateway";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apigateway");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public SubscribersClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SubscribersClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

