/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.apigateway;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.apigateway.UsagePlansAsync;
import com.oracle.bmc.apigateway.model.UsagePlan;
import com.oracle.bmc.apigateway.model.UsagePlanCollection;
import com.oracle.bmc.apigateway.requests.ChangeUsagePlanCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.DeleteUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.GetUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.ListUsagePlansRequest;
import com.oracle.bmc.apigateway.requests.UpdateUsagePlanRequest;
import com.oracle.bmc.apigateway.responses.ChangeUsagePlanCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.DeleteUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.GetUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.ListUsagePlansResponse;
import com.oracle.bmc.apigateway.responses.UpdateUsagePlanResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsagePlansAsyncClient
extends BaseAsyncClient
implements UsagePlansAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("USAGEPLANS").serviceEndpointPrefix("").serviceEndpointTemplate("https://apigateway.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(UsagePlansAsyncClient.class);

    UsagePlansAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeUsagePlanCompartmentResponse> changeUsagePlanCompartment(ChangeUsagePlanCompartmentRequest request, AsyncHandler<ChangeUsagePlanCompartmentRequest, ChangeUsagePlanCompartmentResponse> handler) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeUsagePlanCompartmentDetails(), "changeUsagePlanCompartmentDetails is required");
        return this.clientCall(request, ChangeUsagePlanCompartmentResponse::builder).logger(LOG, "changeUsagePlanCompartment").serviceDetails("UsagePlans", "ChangeUsagePlanCompartment", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/ChangeUsagePlanCompartment").method(Method.POST).requestBuilder(ChangeUsagePlanCompartmentRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeUsagePlanCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeUsagePlanCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateUsagePlanResponse> createUsagePlan(CreateUsagePlanRequest request, AsyncHandler<CreateUsagePlanRequest, CreateUsagePlanResponse> handler) {
        Objects.requireNonNull(request.getCreateUsagePlanDetails(), "createUsagePlanDetails is required");
        return this.clientCall(request, CreateUsagePlanResponse::builder).logger(LOG, "createUsagePlan").serviceDetails("UsagePlans", "CreateUsagePlan", "").method(Method.POST).requestBuilder(CreateUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(UsagePlan.class, CreateUsagePlanResponse.Builder::usagePlan).handleResponseHeaderString("etag", CreateUsagePlanResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateUsagePlanResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateUsagePlanResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<DeleteUsagePlanResponse> deleteUsagePlan(DeleteUsagePlanRequest request, AsyncHandler<DeleteUsagePlanRequest, DeleteUsagePlanResponse> handler) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteUsagePlanResponse::builder).logger(LOG, "deleteUsagePlan").serviceDetails("UsagePlans", "DeleteUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/DeleteUsagePlan").method(Method.DELETE).requestBuilder(DeleteUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteUsagePlanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetUsagePlanResponse> getUsagePlan(GetUsagePlanRequest request, AsyncHandler<GetUsagePlanRequest, GetUsagePlanResponse> handler) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetUsagePlanResponse::builder).logger(LOG, "getUsagePlan").serviceDetails("UsagePlans", "GetUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/GetUsagePlan").method(Method.GET).requestBuilder(GetUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsagePlan.class, GetUsagePlanResponse.Builder::usagePlan).handleResponseHeaderString("etag", GetUsagePlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetUsagePlanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListUsagePlansResponse> listUsagePlans(ListUsagePlansRequest request, AsyncHandler<ListUsagePlansRequest, ListUsagePlansResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListUsagePlansResponse::builder).logger(LOG, "listUsagePlans").serviceDetails("UsagePlans", "ListUsagePlans", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/ListUsagePlans").method(Method.GET).requestBuilder(ListUsagePlansRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(UsagePlanCollection.class, ListUsagePlansResponse.Builder::usagePlanCollection).handleResponseHeaderString("opc-request-id", ListUsagePlansResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListUsagePlansResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListUsagePlansResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateUsagePlanResponse> updateUsagePlan(UpdateUsagePlanRequest request, AsyncHandler<UpdateUsagePlanRequest, UpdateUsagePlanResponse> handler) {
        Validate.notBlank((String)request.getUsagePlanId(), (String)"usagePlanId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateUsagePlanDetails(), "updateUsagePlanDetails is required");
        return this.clientCall(request, UpdateUsagePlanResponse::builder).logger(LOG, "updateUsagePlan").serviceDetails("UsagePlans", "UpdateUsagePlan", "https://docs.oracle.com/iaas/api/#/en/api-gateway/20190501/UsagePlan/UpdateUsagePlan").method(Method.PUT).requestBuilder(UpdateUsagePlanRequest::builder).basePath("/20190501").appendPathParam("usagePlans").appendPathParam(request.getUsagePlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateUsagePlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateUsagePlanResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public UsagePlansAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)UsagePlansAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(UsagePlansAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)UsagePlansAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)UsagePlansAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)UsagePlansAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)UsagePlansAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public UsagePlansAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)UsagePlansAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, UsagePlansAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "apigateway";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"apigateway");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public UsagePlansAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new UsagePlansAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

